/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: tmerror.h
   Description of exported objects of tmerror.c
 */

extern int errno;

#define ERRARGLEN 80       /* max length of argument arrays below */
extern char errpos[];      /* describes position of the error */
extern char errarg[];      /* contains an argument to the error message */

extern void error();       /* general error handler */
extern void sys_error();   /* system error handler (using errno) */
extern void docrash();     /* internal error handler */

extern void line_error();  /* error handler that supplies line number */

extern void init_error();  /* init routine */
extern void stat_error();  /* give statistics */

extern void errcheck();    /* check on errors */

/* error codes for tm class of errors. */
typedef enum en_tmerrcode {
    ERREND,        /* guard: end of error table */
    SYNTAXERR,
    CRASH,
    ERRDET,
    NOROOM,
    NONAME,
    BADTAG,
    NOEXPR,
    BUFOVER,
    NOCLOSEBRAC,
    VARNOTFOUND,
    BADDOTCOM,
    UNEXPECTDOT,
    UNEXPECTEOF,
    UNEXPECTEOL,
    NOSUCHFN,
    TOOMANYARG,
    MISSINGPAR,
    BADNUMBER,
    BADTOK,
    NOSUCHTYPE,
    NOSUCHCONS,
    NOSUCHELM,
    EXTRATERM,
    BADPAR,
    NOUNDERSCORE,
    BADCONSNM,
    BADTYPENM,
    NOTACONS,
    NOTATUPLE,
    BADPADDING,
    BADRE,
    BADPARNO,
    NOSEP,
    BADEXPR,
    DOUBLEFIELD,
    DOUBLECONS,
    LASTTMERROR		/* the one without the comma */
} tmerrcode;

#define crash(n) docrash(__FILE__, __LINE__,n)
