/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: tmtplelm.c

   template file:      tmtplelm.ct
   datastructure file: tplelm.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

/* Standard UNIX libraries */
#include <stdio.h>

/* Standard tm library */
#include <tmc.h>

/* Local definitions */
#include "tmdefs.h"

#include "debug.h"
#include "tmtplelm.h"
#include "tmds.h"
#include "tmstring.h"
#include "tmglobal.h"

/* ---- start of /users/reeuwijk/esprit/lib/cllu.ct ---- */

/* routines for tplelm.

   template file:      /users/reeuwijk/esprit/lib/cllu.ct
   datastructure file: tplelm.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)

   The following C pre-processor variables may be defined:
   STAT          If you want code for statistics.
		 Statistics are written to 'FILE *statstream'.
   FATAL(msg)    If you want supply a fatal error handler to print 'msg'.
		 A default is provided.
  
   Possible declaration or #define'ing of statstream
   must be done outside this module.
 */

#ifndef WORDBUFSIZE
#define WORDBUFSIZE 100
#endif

#ifdef STAT
static char tm_allocfreed[] = "%-15s: %6ld allocated, %6ld freed.%s\n";
#endif

static char *tm_srcfile = __FILE__;

#ifndef FATAL
#define FATAL(msg) tmfatal(tm_srcfile,__LINE__,msg)
#endif

/* the possible error messages */
static char tm_outofmemory[] = "out of memory";
static char tm_nilptr[] = "NIL pointer";


#ifndef FATALTAG
#define FATALTAG(tg) tmbadtag(tm_srcfile,__LINE__,tg)
#endif

#ifdef STAT
static long int newcnt_Plain = 0, frecnt_Plain = 0;
static long int newcnt_Foreach = 0, frecnt_Foreach = 0;
static long int newcnt_While = 0, frecnt_While = 0;
static long int newcnt_If = 0, frecnt_If = 0;
static long int newcnt_Set = 0, frecnt_Set = 0;
static long int newcnt_Append = 0, frecnt_Append = 0;
static long int newcnt_Error = 0, frecnt_Error = 0;
static long int newcnt_Exit = 0, frecnt_Exit = 0;
static long int newcnt_Include = 0, frecnt_Include = 0;
static long int newcnt_Copy = 0, frecnt_Copy = 0;
static long int newcnt_Insert = 0, frecnt_Insert = 0;
#endif

/************************************************
 *    new_<cons> and new_<tuple> routines       *
 ************************************************/

#if defined(__STDC__) && __STDC__>0
#endif

/* Allocate a new instance of constructor 'Plain' */
tplelm new_Plain( p_lno, p_plainline )
 int p_lno;
 string p_plainline;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGPlain;
    new->Plain.lno = p_lno;
    new->Plain.plainline = p_plainline;
#ifdef STAT
    newcnt_Plain++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Foreach' */
tplelm new_Foreach( p_lno, p_felist, p_felines )
 int p_lno;
 string p_felist;
 tplelm_list p_felines;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGForeach;
    new->Foreach.lno = p_lno;
    new->Foreach.felist = p_felist;
    new->Foreach.felines = p_felines;
#ifdef STAT
    newcnt_Foreach++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'While' */
tplelm new_While( p_lno, p_whilecond, p_whilelines )
 int p_lno;
 string p_whilecond;
 tplelm_list p_whilelines;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGWhile;
    new->While.lno = p_lno;
    new->While.whilecond = p_whilecond;
    new->While.whilelines = p_whilelines;
#ifdef STAT
    newcnt_While++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'If' */
tplelm new_If( p_lno, p_ifcond, p_ifthen, p_ifelse )
 int p_lno;
 string p_ifcond;
 tplelm_list p_ifthen;
 tplelm_list p_ifelse;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGIf;
    new->If.lno = p_lno;
    new->If.ifcond = p_ifcond;
    new->If.ifthen = p_ifthen;
    new->If.ifelse = p_ifelse;
#ifdef STAT
    newcnt_If++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Set' */
tplelm new_Set( p_lno, p_setline )
 int p_lno;
 string p_setline;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGSet;
    new->Set.lno = p_lno;
    new->Set.setline = p_setline;
#ifdef STAT
    newcnt_Set++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Append' */
tplelm new_Append( p_lno, p_appline )
 int p_lno;
 string p_appline;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGAppend;
    new->Append.lno = p_lno;
    new->Append.appline = p_appline;
#ifdef STAT
    newcnt_Append++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Error' */
tplelm new_Error( p_lno, p_errstr )
 int p_lno;
 string p_errstr;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGError;
    new->Error.lno = p_lno;
    new->Error.errstr = p_errstr;
#ifdef STAT
    newcnt_Error++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Exit' */
tplelm new_Exit( p_lno, p_str )
 int p_lno;
 string p_str;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGExit;
    new->Exit.lno = p_lno;
    new->Exit.str = p_str;
#ifdef STAT
    newcnt_Exit++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Include' */
tplelm new_Include( p_lno, p_fname )
 int p_lno;
 string p_fname;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGInclude;
    new->Include.lno = p_lno;
    new->Include.fname = p_fname;
#ifdef STAT
    newcnt_Include++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Copy' */
tplelm new_Copy( p_lno, p_fname )
 int p_lno;
 string p_fname;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGCopy;
    new->Copy.lno = p_lno;
    new->Copy.fname = p_fname;
#ifdef STAT
    newcnt_Copy++;
#endif
    return (tplelm) new;
}

/* Allocate a new instance of constructor 'Insert' */
tplelm new_Insert( p_lno, p_fname )
 int p_lno;
 string p_fname;
{
    register tplelm new;

    new = (tplelm) malloc( sizeof(*new) );
    if( (char *)new == (char *)0 ){
	FATAL( tm_outofmemory );
    }
    new->next = tplelmNIL;
    new->tag = TAGInsert;
    new->Insert.lno = p_lno;
    new->Insert.fname = p_fname;
#ifdef STAT
    newcnt_Insert++;
#endif
    return (tplelm) new;
}

/**********************************************************
 *    fre_<type> and fre_<type>_list routines             *
 **********************************************************/

#if defined(__STDC__) && __STDC__>0
static void fre_tplelm( tplelm );
#endif

/* free an element of type tplelm */
static void fre_tplelm( e )
 tplelm e;
{
    if( e == tplelmNIL ) return;
    free( (char *) e );
#ifdef STAT
    switch( e->tag ){
	case TAGPlain:
	    frecnt_Plain++;
	    break;

	case TAGForeach:
	    frecnt_Foreach++;
	    break;

	case TAGWhile:
	    frecnt_While++;
	    break;

	case TAGIf:
	    frecnt_If++;
	    break;

	case TAGSet:
	    frecnt_Set++;
	    break;

	case TAGAppend:
	    frecnt_Append++;
	    break;

	case TAGError:
	    frecnt_Error++;
	    break;

	case TAGExit:
	    frecnt_Exit++;
	    break;

	case TAGInclude:
	    frecnt_Include++;
	    break;

	case TAGCopy:
	    frecnt_Copy++;
	    break;

	case TAGInsert:
	    frecnt_Insert++;
	    break;

	default:
	    FATALTAG( e->tag );
	}
#endif
}

#if defined(__STDC__) && __STDC__>0
static void fre_tplelm_list( tplelm_list );
#endif

/**********************************************************
 *    rfre_<type> and rfre_<type>_list routines           *
 **********************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/* Recursively free an element of type 'tplelm'
   and all elements in it.
 */
void rfre_tplelm( e )
 tplelm e;
{
    if( e == tplelmNIL ) return;
    switch( e->tag ){
	case TAGPlain:
	    rfre_int( e->Plain.lno );
	    rfre_string( e->Plain.plainline );
	    break;

	case TAGForeach:
	    rfre_int( e->Foreach.lno );
	    rfre_string( e->Foreach.felist );
	    rfre_tplelm_list( e->Foreach.felines );
	    break;

	case TAGWhile:
	    rfre_int( e->While.lno );
	    rfre_string( e->While.whilecond );
	    rfre_tplelm_list( e->While.whilelines );
	    break;

	case TAGIf:
	    rfre_int( e->If.lno );
	    rfre_string( e->If.ifcond );
	    rfre_tplelm_list( e->If.ifthen );
	    rfre_tplelm_list( e->If.ifelse );
	    break;

	case TAGSet:
	    rfre_int( e->Set.lno );
	    rfre_string( e->Set.setline );
	    break;

	case TAGAppend:
	    rfre_int( e->Append.lno );
	    rfre_string( e->Append.appline );
	    break;

	case TAGError:
	    rfre_int( e->Error.lno );
	    rfre_string( e->Error.errstr );
	    break;

	case TAGExit:
	    rfre_int( e->Exit.lno );
	    rfre_string( e->Exit.str );
	    break;

	case TAGInclude:
	    rfre_int( e->Include.lno );
	    rfre_string( e->Include.fname );
	    break;

	case TAGCopy:
	    rfre_int( e->Copy.lno );
	    rfre_string( e->Copy.fname );
	    break;

	case TAGInsert:
	    rfre_int( e->Insert.lno );
	    rfre_string( e->Insert.fname );
	    break;

	default:
	    FATALTAG( e->tag );
    }
    fre_tplelm( e );
}

/* recursively free a list of elements of type tplelm */
void rfre_tplelm_list( e )
 register tplelm_list e;
{
    register tplelm n;

    while( e!=tplelmNIL ){
	n = e->next;
	rfre_tplelm( e );
	e = n;
    }
}

/**********************************************************
 *    app_<type>_list routines                            *
 **********************************************************/

#if defined(__STDC__) && __STDC__>0
#endif

/******************************************************
 *    print_<type> and print_<type>_list routines     *
 ******************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/*********************************************************
 *    fprint_<type> and fprint_<type>_list routines      *
 *********************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/*********************************************************
 *    rdup_<type> and rdup_<type>_list routines          *
 *********************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/*********************************************************
 *    cmp_<type> and cmp_<type>_list routines            *
 *********************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/*********************************************************
 *    fscan_<type> and fscan_<type>_list routines        *
 *********************************************************/

#if defined(__STDC__) && __STDC__>0
#else
#endif


/*********************************************************
 *    Statistics printing routines                       *
 *********************************************************/

/* give statistics */
void stat_tplelm( f )
 FILE *f;
{
#ifdef STAT
	fprintf(f,tm_allocfreed,"Plain",newcnt_Plain,frecnt_Plain,((newcnt_Plain==frecnt_Plain)? "": "<-"));
	fprintf(f,tm_allocfreed,"Foreach",newcnt_Foreach,frecnt_Foreach,((newcnt_Foreach==frecnt_Foreach)? "": "<-"));
	fprintf(f,tm_allocfreed,"While",newcnt_While,frecnt_While,((newcnt_While==frecnt_While)? "": "<-"));
	fprintf(f,tm_allocfreed,"If",newcnt_If,frecnt_If,((newcnt_If==frecnt_If)? "": "<-"));
	fprintf(f,tm_allocfreed,"Set",newcnt_Set,frecnt_Set,((newcnt_Set==frecnt_Set)? "": "<-"));
	fprintf(f,tm_allocfreed,"Append",newcnt_Append,frecnt_Append,((newcnt_Append==frecnt_Append)? "": "<-"));
	fprintf(f,tm_allocfreed,"Error",newcnt_Error,frecnt_Error,((newcnt_Error==frecnt_Error)? "": "<-"));
	fprintf(f,tm_allocfreed,"Exit",newcnt_Exit,frecnt_Exit,((newcnt_Exit==frecnt_Exit)? "": "<-"));
	fprintf(f,tm_allocfreed,"Include",newcnt_Include,frecnt_Include,((newcnt_Include==frecnt_Include)? "": "<-"));
	fprintf(f,tm_allocfreed,"Copy",newcnt_Copy,frecnt_Copy,((newcnt_Copy==frecnt_Copy)? "": "<-"));
	fprintf(f,tm_allocfreed,"Insert",newcnt_Insert,frecnt_Insert,((newcnt_Insert==frecnt_Insert)? "": "<-"));
#else
	f = f; /* to prevent 'f unused' from compiler and lint */
#endif
}

/* ---- end of /users/reeuwijk/esprit/lib/cllu.ct ---- */
