#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include "Signal.h"
#include "SignalmgrP.h"

static XtResource resources[] = {
  { XtNscrollbarWidth, XtCDimension, XtRDimension, sizeof(Dimension), 
      XtOffset(SignalmgrWidget, signalmgr.scrollbar_width), XtRImmediate, (XtPointer) 20},
  { XtNlabelWidth, XtCDimension, XtRDimension, sizeof(Dimension), 
      XtOffset(SignalmgrWidget, signalmgr.label_width), XtRImmediate, (XtPointer) 60},
  { XtNlabelHeight, XtCDimension, XtRDimension, sizeof(Dimension), 
      XtOffset(SignalmgrWidget, signalmgr.label_height), XtRImmediate, (XtPointer) 40},
  { XtNoriginChanged, XtCCallback, XtRCallback, sizeof(XtCallbackList),
      XtOffset(SignalmgrWidget, signalmgr.origin_changed), XtRImmediate, NULL},
  { XtNwidgetsShown, XtCWidgetsShown, XtRInt, sizeof(int),
      XtOffset(SignalmgrWidget, signalmgr.widgets_shown), XtRImmediate, (XtPointer) 5},
};

void SignalmgrClassPartInitialize();
void SignalmgrInitialize();
XtGeometryResult SignalmgrQueryGeometry();
XtGeometryResult SignalmgrGeometryManager();
void SignalmgrChangeManaged();
void SignalmgrResize();

externaldef(signalmgrclassrec) SignalmgrClassRec signalmgrClassRec = {
  { /******* CorePart *******/
    /* superclass	    */	(WidgetClass) &compositeClassRec,
    /* class_name	    */	"Signalmgr",
    /* widget_size	    */	sizeof(SignalmgrRec),
    /* class_initialize     */  NULL,
    /* class_part_initialize*/	SignalmgrClassPartInitialize,
    /* class_inited	    */	FALSE,
    /* initialize	    */	SignalmgrInitialize,
    /* initialize_hook      */	NULL,		
    /* realize		    */	XtInheritRealize,
    /* actions		    */	NULL,
    /* num_actions	    */	0,
    /* resources	    */	resources,
    /* num_resources	    */	XtNumber(resources),
    /* xrm_class	    */	NULLQUARK,
    /* compress_motion      */	FALSE,
    /* compress_exposure    */	TRUE,
    /* compress_enterleave  */  FALSE,
    /* visible_interest     */	FALSE,
    /* destroy		    */	NULL,
    /* resize		    */	SignalmgrResize,
    /* expose		    */	NULL,
    /* set_values	    */	NULL,
    /* set_values_hook      */	NULL,			
    /* set_values_almost    */	XtInheritSetValuesAlmost,  
    /* get_values_hook      */	NULL,			
    /* accept_focus	    */	NULL,
    /* version		    */	XtVersion,
    /* callback_offsets     */  NULL,
    /* tm_table		    */  NULL,
    /* query_geometry	    */  NULL, /*SignalmgrQueryGeometry, */
    /* display_accelerator  */	NULL,
    /* extension	    */  NULL
  },
  { /**** CompositePart *****/
    /* geometry_handler     */  SignalmgrGeometryManager,
    /* change_managed       */  SignalmgrChangeManaged,
    /* insert_child	    */  XtInheritInsertChild,
    /* delete_child	    */  XtInheritDeleteChild,
    /* extension	    */  NULL
  },
  { /**** SignalmgrPart *****/
    /* mumbojumbo           */  1
  }
};

externaldef(signalmgrwidgetclass) WidgetClass signalmgrWidgetClass = (WidgetClass) &signalmgrClassRec;

void SignalmgrClassPartInitialize(){};

void do_layout();
void try_do_layout();

static void Scroll(sw, w, pos)
ScrollbarWidget sw;
SignalmgrWidget w;
XtPointer pos;
{
    if((int)pos > 0){
       w->signalmgr.scroll++;
       do_layout(w);
    } else {
       if(w->signalmgr.scroll>0){
         w->signalmgr.scroll--; 
         do_layout(w);
       }
    }
}

static void reset_length_cash(w)
SignalmgrWidget w;
{
    w->signalmgr.signal_length_cash = 0;
}

static void update_length_cash(w, signal)
SignalmgrWidget w;
SignalWidget signal;
{
    int i;
    XtVaGetValues(signal,
	XtNsampleLength, &i,
	XtNtimeScale, &(w->signalmgr.time_scale),
    NULL);
    if(w->signalmgr.signal_length_cash < i)w->signalmgr.signal_length_cash = i;
}

static int length_cash(w)
SignalmgrWidget w;
{
     return w->signalmgr.signal_length_cash;
}

static void ReportNewPosition(w)
SignalmgrWidget w;
{
  XtCallCallbacks(w, XtNoriginChanged, w->signalmgr.signal_scroll);
}

static void RepositionSignals(w, indent)
SignalmgrWidget w;
int indent;
{
    int i;
    for(i=0;i<w->composite.num_children;i++)
      if(XtIsSubclass(w->composite.children[i], signalWidgetClass)){
        XtVaSetValues(w->composite.children[i],
		XtNorigin, w->signalmgr.signal_scroll,
		NULL);
      }
}

void SetScrollBarThumb(w)
SignalmgrWidget w;
{
    XawScrollbarSetThumb(w->signalmgr.hscroll,
	w->signalmgr.signal_scroll/(float)length_cash(w),
	(w->core.width/w->signalmgr.time_scale)/(float)length_cash(w));
}

void SignalmgrCallbackSetOrigin(w, smw, origin)
Widget w;
SignalmgrWidget smw;
int origin;
{
  smw->signalmgr.signal_scroll = origin;
  RepositionSignals(smw, origin);
  SetScrollBarThumb(smw);
}

static void ScrollSignals(sw, w, pos)
ScrollbarWidget sw;
SignalmgrWidget w;
XtPointer pos;
{
    w->signalmgr.signal_scroll +=
	((int)pos > 0?1:-1)*((2*w->core.width)/(3*w->signalmgr.time_scale));
    if(w->signalmgr.signal_scroll<0)w->signalmgr.signal_scroll = 0;

    RepositionSignals(w, w->signalmgr.signal_scroll);
    SetScrollBarThumb(w);
    ReportNewPosition(w);
}

static void ScrollSignalsSmooth(sw, w, perc_ptr)
ScrollbarWidget sw;
SignalmgrWidget w;
XtPointer perc_ptr;
{
  float perc = *(float *)perc_ptr;
  int new_scroll = length_cash(w)*perc;
  if(w->signalmgr.signal_scroll != new_scroll){
    w->signalmgr.signal_scroll = new_scroll;
    RepositionSignals(w, w->signalmgr.signal_scroll); 
    ReportNewPosition(w);
  }
}

void SignalmgrInitialize(request, new)
SignalmgrWidget request, new;
{
    if(new->core.width==0)new->core.width = 252;
    if(new->core.height==0){
      if(new->signalmgr.widgets_shown==0){
        new->core.height = 275;
      } else { new->core.height = new->signalmgr.widgets_shown * 
	  new->signalmgr.label_height + new->signalmgr.scrollbar_width;
      }
    }
    new->signalmgr.geometry_cache.request_mode = (XtGeometryMask)0;
    new->signalmgr.vscroll = XtVaCreateManagedWidget("",
	scrollbarWidgetClass, new,
	XtNorientation, XtorientVertical, NULL);
    XtAddCallback(new->signalmgr.vscroll, XtNscrollProc, Scroll, new);
    new->signalmgr.hscroll = XtVaCreateManagedWidget("",
	scrollbarWidgetClass, new,
	XtNorientation, XtorientHorizontal, NULL);
    XtAddCallback(new->signalmgr.hscroll, XtNscrollProc, ScrollSignals, new);
    XtAddCallback(new->signalmgr.hscroll, XtNjumpProc, ScrollSignalsSmooth, new);
    new->signalmgr.label = XtVaCreateManagedWidget(XtName(new),
	labelWidgetClass, new, NULL);
    new->signalmgr.scroll = 0;
    new->signalmgr.signal_scroll = 0;
    new->signalmgr.time_scale = 1;
};

static void SignalmgrResize(w)
SignalmgrWidget w;
{
  do_layout(w);
}

static void SignalmgrChangeManaged(w)
SignalmgrWidget w;
{
    do_layout(w);
}

#define max(a,b) ((a)>(b)?(a):(b))

static void MiniChild(w, width, height)
SignalmgrWidget w;
Dimension *width, *height;
{
  XtWidgetGeometry req, pref;
  pref.width = pref.height = 0;
  pref.request_mode = CWWidth | CWHeight;
  (void) XtQueryGeometry(w, &req, &pref);
  *width = pref.width;
  *height = pref.height;
}

static XtGeometryResult SignalmgrQueryGeometry(w, req, pref)
SignalmgrWidget w;
XtWidgetGeometry *req, *pref;
{
  return(XtGeometryNo);
}  

static void try_do_layout(w, req)
SignalmgrWidget w;
XtWidgetGeometry *req;
{
    XtWidgetGeometry  pref;
    if(req->width > w->core.width || req->height > w -> core.height){
      (void) XtMakeGeometryRequest(w, req, &pref);
    }
    do_layout(w);
}

static void ConfigureBorderedWidget(w, x, y, width, height)
Widget w;
Dimension x, y, width, height;
{
  XtConfigureWidget(w, x, y,
	width - 2*w->core.border_width,
	height - 2*w->core.border_width,
	w->core.border_width);
}

static void do_layout(w)
SignalmgrWidget w;
{
  int i;
  Dimension
	a = w->signalmgr.scrollbar_width,
	b = w->signalmgr.label_width,
	g = w->signalmgr.label_height;
  Dimension
	h = a + b,
	d = w->core.height - a;
  Dimension
	c = w->core.width - h;
  Boolean Odd = True;
  int n = 0;
  int visible = d/g;
  int max_n = (w->composite.num_children - 2) / 2;
  
  if(w->signalmgr.scroll>=max_n-visible)w->signalmgr.scroll=max_n-visible;
  if(max_n<visible){
    w->signalmgr.scroll=0;
    XawScrollbarSetThumb(w->signalmgr.vscroll, 1.0, 0.0);
  } else {
    XawScrollbarSetThumb(w->signalmgr.vscroll, w->signalmgr.scroll/(float)max_n, visible/(float)max_n);
  }
  reset_length_cash(w);
  for(i=0; i<w->composite.num_children; i++){
    Widget child = w->composite.children[i];
    if(child->core.managed){
      if(child==w->signalmgr.vscroll){
        ConfigureBorderedWidget(child, 0, 0, a, d);
      } else if(child==w->signalmgr.hscroll){
        ConfigureBorderedWidget(child, h, d, c, a);
      } else if(child==w->signalmgr.label){
        ConfigureBorderedWidget(child, 0, d, h, a);
      } else if(Odd){
        Odd = False;
        if(n>=w->signalmgr.scroll){
	    ConfigureBorderedWidget(child, a, (n-w->signalmgr.scroll)*g, b, g);
            if(XtIsRealized(child))XtMapWidget(child);
        } else {
	    XtUnmapWidget(child);
        }
      } else {
        Odd = True;
        if(n>=w->signalmgr.scroll){
            ConfigureBorderedWidget(child, h, (n-w->signalmgr.scroll)*g, c, g);
            if(XtIsRealized(child))XtMapWidget(child);
            update_length_cash(w, child);
        } else {
	    XtUnmapWidget(child);
        }
        n++;
      }
    }
  }
  SetScrollBarThumb(w);
}

static XtGeometryResult SignalmgrGeometryManager(w, ch_req, ch_pref)
Widget w;
XtWidgetGeometry *ch_req, *ch_pref;
{
  return(XtGeometryNo);
}
