-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
makebb: using(usub, terminalio, safewindow, rManager, common) linking(ac_noart) process (init: usubIn)
  declare
    parms: usub; -- initialization parameters
    openwindow: safewindowFn; -- port to open a window
    rm: rManager; -- ports to resource manager
    calendarwindow: terminalCM; -- window opened by makebb
    ac: accessFn; -- access control
    resource: polymorph; -- polymorph resource
    junk: charstring;
  begin
    -- Algorithm:
    -- 0. Save  rm
    -- 1. Get services: OpenWindow
    -- 2. Create a new window 
    -- 3. Post its terminal into the resource manager
    -- 4. prompt for when you're ready to shut down
    receive parms from init;
    ac <- procedure of process ac_noart;
    -- 0.
    BLOCK
      declare
      BEGIN
        rm := parms.io.resource;
        -- 1.
        unwrap openwindow from rm.get("OpenWindow", "") {init};
        -- 2.
        calendarwindow <- openwindow("Bulletin Board", "-Wh 20 -Ww 40");
        -- 3.
        wrap copy of calendarwindow.terminal.putLine as resource;
        call rm.post("BB", resource, ac);
        -- 4. 
        call calendarwindow.terminal.putLine("BB started");
        call parms.io.terminal.putString("push enter to quit:");
        call parms.io.terminal.Getstring(junk);
        call rm.delete("BB");
        return parms;
      END BLOCK;
    
  end process
