-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
appt_scheduler_registrant:  USING (events, appt_scheduler_member)

DEFINITIONS

-- Registrant -> Appt_Scheduler calls:
	Add_Member : callmessage (
		WhoAmI: Member,
		Request_Plan_Info : Request_Plan_Info_Out, 
		Inform_Schedule : Inform_Schedule_Out, 
		Inform_Cancel : Inform_Cancel_Out, 
		Shutdown : Shutdown_Out, 
		Reset_Member : Reset_Member_Out,
		Initiate_Plan: Initiate_Plan_Out,
		Initiate_Schedule: Initiate_Schedule_Out,
		Initiate_Cancel: Initiate_Cancel_Out,
		List_Members: List_Members_Out,
		List_Events: List_Events_Out,
		Depart: Depart_Out
		 )
		constant( WhoAmI, Request_Plan_Info, Inform_Schedule, Inform_Cancel, Shutdown, Reset_Member )
		exit {full}
		exception Add_Failed{full(WhoAmI), full(Request_Plan_Info), full(Inform_Schedule), full(Inform_Cancel), full(Shutdown), full(Reset_Member)};
	Add_Member_In : inport of Add_Member { full(WhoAmI), full(Request_Plan_Info), full(Inform_Schedule), full(Inform_Cancel), full(Shutdown), full(Reset_Member)};
	Add_Member_Out : outport of Add_Member_In;
	

end DEFINITIONS
