-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
ufilter: using(ufilter_init, terminalio, rManager, sysRManager, safewindow) process(init: ufilter_initIn)
  declare
    parms: ufilter_init; -- initialization callmessage
    
    -- input ports
    putString: putStringQ; 
    putLine: putStringQ;
    getString: getstringQ;
    putChar: putcharQ;
    getChar: getCharQ;
    post: PostResourceQ;
    insert: InsertResourceQ;
    get: GetResourceQ;
    remove: GetResourceQ;
    delete: DeleteResourceQ;
    quit: master_filterIn;
    
    -- output ports
    terminal: terminalFunctions;
    resource: sysRManager;
    opentracewindow: safewindowFn;
    
    -- callmessages
    putStringCM: putStringIntf;
    putLineCM: putStringIntf;
    getStringCM: getStringIntf;
    putCharCM: putCharIntf;
    getCharCM: getCharIntf;
    postCM: PostResource;
    insertCM: InsertResource;
    getCM: GetResource;
    removeCM: GetResource;
    deleteCM: DeleteResource;
    quitCM: master_filter;
    
    -- state
    continue: boolean;
    username: charstring;
    tracewindow: terminalCM;
  begin
    receive parms from init;
    new parms.filteredterminal;
    new parms.filteredresource;
    new putString; connect parms.filteredterminal.putString to putString;
    new putLine; connect parms.filteredterminal.putLine to putLine;
    new getString; connect parms.filteredterminal.getString to getString;
    new putChar; connect parms.filteredterminal.putChar to putChar;
    new getChar; connect parms.filteredterminal.getChar to getChar;
    new post; connect parms.filteredresource.post to post;
    new insert; connect parms.filteredresource.insert to insert;
    new get; connect parms.filteredresource.get to get;
    new remove; connect parms.filteredresource.remove to remove;
    new delete; connect parms.filteredresource.delete to delete;
    new quit; connect parms.quit to quit;
    terminal := parms.terminal;
    resource := parms.resource;
    username := parms.username;
    return parms;
    unwrap opentracewindow from resource.get(username, "OpenTraceWindow", "filter "|username) {init};
    tracewindow <- opentracewindow("trace filter "|username, "-Wh 5 -Ww 40 -inverse");
    continue <- 'true';
    while (continue)
      repeat
        select
          event putString
            receive putStringCM from putString;
            call tracewindow.terminal.PutLine("Received putString request: forwarded to window");
            send putStringCM to terminal.putString;
          event putLine
            receive putLineCM from putLine;
            call tracewindow.terminal.PutLine("Received putLine request: forwarded to window");
            send putLineCM to terminal.putLine;
          event getString
            receive getStringCM from getString;
            call tracewindow.terminal.PutLine("Received getString request: forwarded to window");
            send getStringCM to terminal.getString;
          event putChar
            receive putCharCM from putChar;
            call tracewindow.terminal.PutLine("Received putChar request: forwarded to window");
            send putCharCM to terminal.putChar;
          event getChar
            receive getCharCM from getChar;
            call tracewindow.terminal.PutLine("Received getChar request: forwarded to window");
            send getCharCM to terminal.getChar;
          event post
            receive postCM from post;
            call tracewindow.terminal.PutLine("Received Post RQ: forwarded to Resource Manager");
            block
              begin
                call resource.post(username, postCM.ResourceName, postCM.Resource, postCM.AccessFunction);
                return postCM;
              on (sysPostResource.DuplicateName)
                return postCM exception DuplicateName;
              on (others)
                discard postCM;
              end block;
          event insert
            receive insertCM from insert;
            call tracewindow.terminal.PutLine("Received Insert RQ: forwarded to Resource Manager");
            block
              begin
                call resource.insert(username, insertCM.ResourceName, insertCM.Resource, insertCM.AccessFunction);
                return insertCM;
              on (sysInsertResource.DuplicateName)
                return insertCM exception DuplicateName;
              on (others)
                discard insertCM;
              end block;
          event get
            receive getCM from get;
            call tracewindow.terminal.PutLine("Received Get RQ: forwarded to Resource Manager");
            block
              begin
                call resource.get(username, getCM.ResourceName, getCM.parameter, getCM.Resource);
                return getCM;
              on (sysGetResource.NotFound)
                return getCM exception NotFound;
              on (sysGetResource.AccessDenied)
                return getCM exception AccessDenied;
              on (others)
                discard getCM;
              end block;
          event remove
            receive removeCM from remove;
            call tracewindow.terminal.PutLine("Received Remove RQ: forwarded to Resource Manager");
            block
              begin
                call resource.remove(username, removeCM.ResourceName, removeCM.parameter, removeCM.Resource);
                return removeCM;
              on (sysGetResource.NotFound)
                return removeCM exception NotFound;
              on (sysGetResource.AccessDenied)
                return removeCM exception AccessDenied;
              on (others)
                discard removeCM;
              end block;
          event delete
            receive deleteCM from delete;
            call tracewindow.terminal.PutLine("Received Delete RQ: forwarded to Resource Manager");
            block
              begin
                call resource.delete(username, deleteCM.ResourceName);
                return deleteCM;
              on (sysDeleteResource.NotOwner)
                return deleteCM exception NotOwner;
              on (others)
                discard deleteCM;
              end block;
          event quit
            receive quitCM from quit;
            call tracewindow.terminal.PutLine("Received Quit RQ from master");
            continue <- 'false';
            call tracewindow.terminal.PutLine("Returning");
            return quitCM;
          otherwise
          end select;
      end while;
    call tracewindow.terminal.PutLine("Shutting Down");
  end process
