-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
usermonitor:  using(usermonitor, terminalio, rManager, master_monitor, umain, safewindow) process (init: usermonitorIn)
  declare 
    parms: usermonitor;
    -- call parameters
    username: charstring;
    terminal: terminalFunctions;
    resource: rManager;
    
    -- trace data
    opentracewindow: safewindowFn;
    tracewindow: terminalCM;
    
    -- call site
    callsite: useraccessOut;
    
    -- notification port
    notify: master_monitorOut;
  begin
    -- procedure to generate callmessage granting user 
    -- and to automatically notify master when the application dies
    receive parms from init;
    connect callsite to parms.callsite;
    notify := parms.notify;
    username := parms.username;
    terminal := parms.terminal;
    resource := parms.resource;
    unwrap opentracewindow from resource.get("OpenTraceWindow", "monitor "|username) {init};
    tracewindow <- opentracewindow("trace monitor "|username, "-Wh 5 -Ww 40 -inverse");
    call tracewindow.terminal.PutLine("Initialized");
    return parms;
    BLOCK
      BEGIN
        call tracewindow.terminal.PutLine("Calling master with callmessage for user");
        call callsite(username, terminal, resource);
        call tracewindow.terminal.PutLine("User returned normally");
        call tracewindow.terminal.PutLine("Notifying master");
        call notify(username, 'true');
      on (useraccess.discarded)
        call tracewindow.terminal.PutLine("User returned abnormally");
        call tracewindow.terminal.PutLine("Notifying master");
        call notify(username, 'false');
      END BLOCK;
    call tracewindow.terminal.PutLine("Terminating");
  end process
