-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: difference_time_ranges.p
-- Author: Arthur P. Goldberg

-- find the difference between two time ranges
-- call difference_time_ranges( Input_Time_Range_1, Input_Time_Range_2,
-- Output_Time_Range_1, Output_Time_Range_2 );
-- compute Input_Time_Range_1 - Input_Time_Range_2
-- Input_Time_Range_1 = Addendum
-- Input_Time_Range_2 = Subtrahend

-- Algorithm:
-- if ( Addendum.Begin_Time < Subtrahend.Begin_Time ) then
	-- Output_Time_Range_1 := [ Addendum.Begin_Time, 
	-- Min( Subtrahend.Begin_Time, Addendum.End_Time) )
-- else
	-- Output_Time_Range_1 := [ Pos_Inf, Pos_Inf) 
-- end if;

-- if ( Subtrahend.End_Time < Addendum.End_Time ) then
	-- Output_Time_Range_2 := [ Max( Subtrahend.End_Time, Addendum.Begin_Time),
	-- Addendum.End_Time )
-- else
	-- Output_Time_Range_2 := [ Pos_Inf, Pos_Inf) 
-- end if;

-- [Pos_Inf, Pos_Inf) = the empty time range

difference_time_ranges: USING( times, terminalIO )
LINKING(min_time, max_time, comp_times)

PROCESS ( Call_Port : Time_Range_In2_Out2_Procedure_Receiver )
	DECLARE
		TCM : Time_Range_In2_Out2_INTFACE;
		Max_Begin_Time : Time_Value;
		Min_End_Time : Time_Value;
		Min_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Max_Time : Time_Value_Call2_Return1_INTFACE_Caller;
		Comp_Times : Time_Value_Call2_Return_Boolean_INTFACE_Caller;
		Addendum : Time_Range;
		Subtrahend : Time_Range;
	BEGIN
		RECEIVE TCM FROM Call_Port;

	-- other names that capture the semantics
		new Addendum;
		new Subtrahend;
		Addendum := TCM.Input_Time_Range_1;
		Subtrahend := TCM.Input_Time_Range_2;

  		Min_Time <- procedure of process min_time; 
  		Max_Time <- procedure of process max_time;
		Comp_Times <- procedure of process comp_times; 

		new TCM.Output_Time_Range_1;
		new TCM.Output_Time_Range_2;

-- Algorithm:
		if ( Comp_Times( Addendum.Begin_Time, Subtrahend.Begin_Time ) ) then
			TCM.Output_Time_Range_1.Begin_Time := Addendum.Begin_Time; 
			TCM.Output_Time_Range_1.End_Time := 
				Min_Time ( Subtrahend.Begin_Time, Addendum.End_Time );
		else
			unite TCM.Output_Time_Range_1.Begin_Time.The_Infinity from 'Pos_Inf';
			unite TCM.Output_Time_Range_1.End_Time.The_Infinity from 'Pos_Inf';
		end if;

		if ( Comp_Times( Subtrahend.End_Time, Addendum.End_Time ) ) then
			TCM.Output_Time_Range_2.Begin_Time := 
				Max_Time ( Subtrahend.End_Time, Addendum.Begin_Time );
			TCM.Output_Time_Range_2.End_Time := 
				Addendum.End_Time;
		else
			unite TCM.Output_Time_Range_2.Begin_Time.The_Infinity from 'Pos_Inf';
			unite TCM.Output_Time_Range_2.End_Time.The_Infinity from 'Pos_Inf';
		end if;

		return TCM;

end process
