-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
hhmmtotime: using(calendar_display) process (init: StringToTimeIn)
  declare
    parms: StringToTime; -- call parameters
    input: charstring; -- copy of input
    junk: charstring; -- characters ignored
    junkc: char; -- character ignored
    hh: charstring; -- hours field
    mm: charstring; -- minutes field
    am: boolean; -- true if am
    conversion: charstring; -- legal digits
    time: integer; -- the time
    hours: integer; -- integer value of hours
    minutes: integer; -- integer value of minutes
  begin
    -- algorithm:
    -- delete leading blanks
    -- hh is all before colon -- must be one or two digits, < 13
    -- mm is exactly two digits after colon < 60
    -- am/pm is two characters after mm, if present
    -- resulting time is number of minutes shown
    receive parms from init;
    conversion <- "0123456789";
    input := parms.string;
    extract junk from c in input where(position of c < position of cc in input where (cc <> ' '));
    extract hh from c in input where(position of c < position of cc in input where (cc = ':'));
    remove junkc from input[0];
    extract mm from c in input where(position of c <= 1);
    if size of input = 0
      then
        am := 'true';
      else
        select(input)
          where("am")
            am := 'true';
          where("pm")
            am := 'false';
          otherwise
            exit Bad;
          end select;
      end if;
    select (size of hh)
      where(1)
        insert '0' into hh at(0);
      where(2)
      otherwise
        exit Bad;
      end select;
    if size of mm <> 2
      then
        exit Bad;
      end if;
    hours := 10*(position of c in conversion where(c=hh[0])) +
            position of c in conversion where(c=hh[1]);
    if hours > 12
      then
        exit Bad;
      end if;
    if hours = 12
      then
        hours := 0;
      end if;
    if am
      then
      else
        hours := hours + 12;
      end if;
    minutes := 10*(position of c in conversion where(c = mm[0])) +
            position of c in conversion where(c = mm[1]);
    if minutes >= 60
      then
        exit Bad;
      end if;
    time := 60*hours + minutes;
    unite parms.time.The_Actual_Time from time;
    return parms;
  on Exit(Bad)
    return parms exception ConversionError;
  on (NotFound)
    return parms exception ConversionError;
  end process
    
