-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: intersect_time_sets.p
-- Author: Arthur P. Goldberg

-- find the itersection of two time sets
-- intersect_time_sets( Input_Time_Set_1, Input_Time_Set_2, Output_Time_Set);

-- Output_Time_Set <- Input_Time_Set_1 intersect Input_Time_Set_2

-- algorithm
-- for time_range_1 in Input_Time_Set_1
-- 	for time_range_2 in Input_Time_Set_2
--			if (time_range_1 intersects time_range_2) then
--				union_insert(intersection(time_range_1, time_range_2) 
--					into Output_Time_Set 
--		end for
--	end for

-- Idea: many optimizations possible, such as taking advangage of order
-- in Time_Sets to look only at Time_Ranges that might intersect

intersect_time_sets: USING( times, timesaux, terminalIO )
LINKING( insert_tr_in_ts , intersect_time_ranges )

PROCESS ( Call_Port : Time_Set_In2_Out1_Procedure_Receiver )
	DECLARE
		TCM : Time_Set_In2_Out1_INTFACE;
		intersect_time_ranges: Time_Range_In2_Out1_Procedure_Caller;
		insert_tr_in_ts : Ins_TR_In_TS_Procedure_Caller;
		Never : Time_Range;
		Inter_Time_Range : Time_Range;
	BEGIN 
		RECEIVE TCM FROM Call_Port;
  intersect_time_ranges <- procedure of process intersect_time_ranges;
		insert_tr_in_ts <- procedure of process insert_tr_in_ts; 

		new Never;
		unite Never.Begin_Time.The_Infinity from 'Pos_Inf';
		unite Never.End_Time.The_Infinity from 'Pos_Inf';

		new TCM.Output_Time_Set;

		for Time_Range_1 in TCM.Input_Time_Set_1 where('true') inspect
			for Time_Range_2 in TCM.Input_Time_Set_2 where('true') inspect

				call intersect_time_ranges( Time_Range_1, Time_Range_2,
					Inter_Time_Range);


				-- the if statement below is an optimization
				if(not(Inter_Time_Range = Never)) then
					call insert_tr_in_ts( Inter_Time_Range, TCM.Output_Time_Set );
				end if;

			end for;
		end for;


		return TCM;

end process
