-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: not_time_set.p
-- Author: Arthur P. Goldberg

-- find the negation of a time set
-- not_time_set( Input_Time_Set, Output_Time_Set);

-- Output_Time_Set <- not (Input_Time_Set)

-- algorithm
--	Always := [ -OO, +OO )
--	Tmp_Time_Range := Always
-- for time_range_1 in Input_Time_Set
--		Later := difference_time_ranges( Tmp_Time_Range, time_range_1, Earlier )  
--		Output_Time_Set := insert_tr_in_ts( Earlier );
--		Tmp_Time_Range := Later
--	end for
-- insert Later in Output_Time_Set

-- Idea: many optimizations possible, such as using insert instead of
--	insert_tr_in_ts, and testing for Nevers

not_time_set: USING( times, terminalIO )
LINKING( insert_tr_in_ts , difference_time_ranges )

PROCESS ( Call_Port : Time_Set_In1_Out1_Procedure_Receiver )
	DECLARE
		TCM : Time_Set_In1_Out1_INTFACE;
		difference_time_ranges : Time_Range_In2_Out2_Procedure_Caller;
		insert_tr_in_ts : Ins_TR_In_TS_Procedure_Caller;
		Always : Time_Range;
		Never : Time_Range;
		Tmp_Time_Range : Time_Range;
		Earlier : Time_Range;
		Later : Time_Range;
	BEGIN 
		RECEIVE TCM FROM Call_Port;
  		difference_time_ranges <- procedure of process difference_time_ranges;
		insert_tr_in_ts <- procedure of process insert_tr_in_ts; 

--	Always := [ -OO, +OO )
		new Always;
		unite Always.Begin_Time.The_Infinity from 'Neg_Inf';
		unite Always.End_Time.The_Infinity from 'Pos_Inf';

--	Always := [ +OO, +OO )
		new Never;
		unite Never.Begin_Time.The_Infinity from 'Pos_Inf';
		unite Never.End_Time.The_Infinity from 'Pos_Inf';

		Tmp_Time_Range := Always;

		new Later;
		Later := Always;

		new TCM.Output_Time_Set ;

		for Time_Range_1 in TCM.Input_Time_Set where('true') inspect

			Later := difference_time_ranges( Tmp_Time_Range,
					Time_Range_1, Earlier )  ;
			Tmp_Time_Range := Later;

			-- Optimization: the if 
			if (not(Earlier = Never)) then
			-- possible Optimization: use Hermes insert instead of insert_tr_in_ts 
				call insert_tr_in_ts( Earlier, TCM.Output_Time_Set );
			end if;

		end for;

		-- Optimization: the if 
		if (not(Later = Never)) then
		-- possible Optimization: use Hermes insert instead of insert_tr_in_ts 
			call insert_tr_in_ts( Later, TCM.Output_Time_Set );
		end if;


		return TCM;

end process
