-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: sel_max_time.p
-- Author: Arthur P. Goldberg

-- a call
-- call sel_max_time ( Input_Time_Value_1, Input_Time_Value_2, Output_Time_Value );

-- Output_Time_Value = the larger time value

sel_max_time : USING( times, terminalIO )

PROCESS ( Call_Port : Time_Value_Call2_Return1_INTFACE_Receiver )
	DECLARE
		TCM : Time_Value_Call2_Return1_INTFACE;
	BEGIN
		RECEIVE TCM FROM Call_Port;
		-- print charstring # "On entry to Sel_Max_Time TCM: ";
		-- call init.std.terminal.putline(TCM);
		-- print TCM;

		select
			where ( TCM.Input_Time_Value_1 = TCM.Input_Time_Value_2 )
				TCM.Output_Time_Value := TCM.Input_Time_Value_1;

			where ( case of TCM.Input_Time_Value_1 = 'An_Infinity' )
				reveal TCM.Input_Time_Value_1.The_Infinity;
				if ( TCM.Input_Time_Value_1.The_Infinity = 'Neg_Inf' ) then
					TCM.Output_Time_Value := TCM.Input_Time_Value_2;
				else
					-- Input_Time_Value_1 is 'Pos_Inf'
					TCM.Output_Time_Value := TCM.Input_Time_Value_1;
				end if;

			where ( case of TCM.Input_Time_Value_2 = 'An_Infinity' )
				reveal TCM.Input_Time_Value_2.The_Infinity;
				if ( TCM.Input_Time_Value_2.The_Infinity = 'Neg_Inf' ) then
					TCM.Output_Time_Value := TCM.Input_Time_Value_1;
				else
					-- Input_Time_Value_2 is 'Pos_Inf'
					TCM.Output_Time_Value := TCM.Input_Time_Value_2;
				end if;

			-- Both Input_Time_Value_1 and Input_Time_Value_2 are 'Actual'
			otherwise
			-- where ( case of TCM.Input_Time_Value_1 = 'Actual' and 
				-- case of TCM.Input_Time_Value_2 = 'Actual' )
				reveal TCM.Input_Time_Value_1.The_Actual_Time;
				reveal TCM.Input_Time_Value_2.The_Actual_Time;
				if ( TCM.Input_Time_Value_1.The_Actual_Time < TCM.Input_Time_Value_2.The_Actual_Time ) then
					TCM.Output_Time_Value := TCM.Input_Time_Value_2;
				else
					TCM.Output_Time_Value := TCM.Input_Time_Value_1;
				end if;


		end select;
		return TCM;
end process
