-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: union_time_sets.p
-- Author: Arthur P. Goldberg

-- find the union among two time sets
-- call union_time_sets( Input_Time_Set_1, Input_Time_Set_2, Output_Time_Set);

-- Output_Time_Set <- Input_Time_Set_1 union Input_Time_Set_2

-- algorithm
-- for time_range_1 in Input_Time_Set_1
--		insert time_range_1 in Output_Time_Set 
--	end for
-- for time_range_2 in Input_Time_Set_2
--		insert time_range_2 in Output_Time_Set 
--	end for

union_time_sets: USING( times, terminalIO )
LINKING( insert_tr_in_ts )

PROCESS ( Call_Port : Time_Set_In2_Out1_Procedure_Receiver )
	DECLARE
		TCM : Time_Set_In2_Out1_INTFACE;
		insert_tr_in_ts : Ins_TR_In_TS_Procedure_Caller;
		New_Output_Time_Set : Time_Set;
		Tmp_Output_Time_Set : Time_Set;
	BEGIN 
		RECEIVE TCM FROM Call_Port;
		insert_tr_in_ts <- procedure of process insert_tr_in_ts; 

		new TCM.Output_Time_Set;
		for Time_Range_1 in TCM.Input_Time_Set_1 where('true') inspect
			call insert_tr_in_ts( Time_Range_1, TCM.Output_Time_Set ); 
		end for;

		for Time_Range_2 in TCM.Input_Time_Set_2 where('true') inspect
			call insert_tr_in_ts( Time_Range_2, TCM.Output_Time_Set ); 
		end for;


		return TCM;

end process
