-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
tracewindow:  using(tracewindow, safewindowgen, safewindow, terminalio, solicitor, common) linking(safewindowgen, solicitor) process (init: tracewindow_filter_initQ)
  declare 
    parms: tracewindow_filter_init; -- request to build filter
    window: terminalCM; -- access to real window
    safewindowgen: safewindowgenFn; -- generate safewindow callmessage
    solicitor: SolicitorOut; -- process to solicit input
    openwindow: safewindowQ; -- open window service port
    terminalQ: terminalQ; -- port for receiving terminal functions as CM
    terminal: terminalFunctions; -- terminal functions for the window
    closeQ: signalQ; -- close service
    putStringQ: putStringQ;	-- print a string
    putLineQ: putStringQ;	-- print a string plus a newline
    getStringQ: getStringQ;	-- read a string 
    putCharQ: putCharQ;	-- print a character
    getCharQ: getCharQ;	-- get a character 
    close: signalPort; -- access to close signal for the window
    SolicitedQ: putStringQ;     -- input from solicitor
    SolicitedQCap: putStringFunc; -- access to solicitor input
    nothing: empty; -- close signal
    putStringCM: putStringIntf; -- putString request
    putLineCM: putStringIntf; -- putLine request
    getStringCM: getStringIntf; -- getString request
    putCharCM: putCharIntf; -- putChar request
    getCharCM: getCharIntf; -- getChar request
    continue: boolean; -- true until null window closed
    singlestep: boolean; -- true if window is in singlestep mode
  begin
    receive parms from init;
    window <- parms.realwindow;
    safewindowgen <- procedure of process safewindowgen;
    new closeQ;
    new putStringQ; new PutLineQ; new getStringQ; new putCharQ;new getCharQ;
    new terminal; new terminalQ;
    connect close to closeQ;
    connect terminal.putString to putStringQ;
    connect terminal.putLine to putLineQ;
    connect terminal.getString to getStringQ;
    connect terminal.putChar to putCharQ;
    connect terminal.getChar to getCharQ;
    call safewindowgen(terminal, close, terminalQ);
    receive parms.tracewindow from terminalQ;
    return parms;
    solicitor <- create of process solicitor;
    new SolicitedQ;
    connect SolicitedQCap to SolicitedQ;
    call solicitor(window.terminal, "", SolicitedQCap);
    singlestep <- 'true';
    
    -- service loop
    continue <- 'true';
    while (continue) 
      repeat
        select
          event putStringQ
            receive putStringCM from putStringQ;
            call window.terminal.putString(putStringCM.string);
            return putStringCM;
          event putLineQ
            receive putLineCM from putLineQ;
            call window.terminal.putLine(putLineCM.string);
            -- if we are singlestepping, wait for response from solicitor
            if singlestep 
              then
                call window.terminal.putString(">");
		select
		  event SolicitedQ
		  otherwise
		  end select;
              end if;
            return putLineCM;
          event getStringQ
            receive getStringCM from getStringQ;
            return getStringCM exception EndOfInput;
          event putCharQ
            receive putCharCM from putCharQ;
            call window.terminal.putChar(putCharCM.char);
            return putCharCM;
          event getCharQ
            receive getCharCM from getCharQ;
            return getCharCM exception EndOfInput;
          event closeQ
            receive nothing from closeQ;
            continue <- 'false';
          event SolicitedQ
            receive putLineCM from SolicitedQ;
            select (putLineCM.string)
              where ("on") -- turn singlestepping on
                singlestep <- 'true';
              where ("off") -- turn singlestepping off
                singlestep <- 'false';
              otherwise
              end select;
            return putLineCM;
          otherwise
          end select;
      end while;
  end process
