/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: linkacts.ch */
/* Author: Andy Lowry */
/* SCCS Info: @(#)linkacts.ch	1.4 3/13/90 */

#include <string.h>
#include <sys/file.h>

#include "cherm.h"
#include "asm.h"

#include "interpform.cd"


#define Prog envp->prog
extern env *envp;

void
link_module(modname)
char *modname;
{
    char *hermpath();

    hobject(Program, record);	/* the filed definition module */
    hobject(Name, charstring);
    char *filename;


    filename = hermpath(modname, ".po");
    chs_lit(Name, filename);
    read(Program, Name);	/* read in from the file */
    insert(Prog@prog__linkedprogs, Program); /* and save it in link table */
}


static char *
hermpath(file, suffix)
char *file;
char *suffix;
{
    char *pathfind();
    char *getenv();
    char *hbindir();
    char *malloc();

    char *path, *bin;
    char *fullfile;


    fullfile = (char *) malloc(strlen(file) + strlen(suffix) + 1);
    strcpy(fullfile, file);
    strcat(fullfile, suffix);

    if ((path = getenv("HSYSPATH")) is nil)
      if ((path = getenv("HPATH")) is nil) {
	bin = hbindir();
	path = malloc(strlen(".:")+strlen(bin)+1);
	strcat(strcpy(path, ".:"), bin);
      }
    return(pathfind(path, fullfile, R_OK));
}
