/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)newtable.ch	1.5 3/13/90 */

#include "cherm.h"

#include "predefined.cd"
#include "interpform.cd"

extern objectp keyqual;

#define Finalize(obj) (*(obj)->tsdr->finalize)(obj, F_DISCARD, nil)

#define new_table(t, qual) h_qcall(o_new_table, qual, t, 0)


status
vec_new_table(dst, newinfo)
objectp dst, newinfo;
{
    status vec_qual();

    lobject(Newqual);

    set_bottom(Newqual);

    if (new_record(Newqual, new_table_info) isnt Normal) goto cleanup;
    if (!vec_qual(Newqual@new_table_info__nonlookup, newinfo)) goto cleanup;
    (void) unite(Newqual@new_table_info__opt_reps, Bottom, option__absent);
    if (new_table(dst, Newqual->value) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    (void) Finalize(Newqual);
    return(FAILURE);
}


static status
vec_qual(qual, newinfo)
objectp qual;
objectp newinfo;
{
    lobject(Infocopy);

    set_bottom(Infocopy);

    if (newinfo) {
	if (copy(Infocopy, newinfo) isnt Normal) 
	  return(FAILURE);
	(void) unite(qual, Infocopy, table_rep_type__vector);
    }
    else {
	(void) unite(qual, Bottom, table_rep_type__vector);
    }
    return(SUCCESS);
}


status
chs_new_table(dst, newinfo)
objectp dst, newinfo;
{
    lobject(Newqual, record);
    lobject(Infocopy);

    set_bottom(Newqual);
    set_bottom(Infocopy);

    if (new_record(Newqual, new_table_info) isnt Normal) goto cleanup;
    if (copy(Infocopy, newinfo) isnt Normal) goto cleanup;
    (void) unite(Newqual@new_table_info__nonlookup, Infocopy,
		 table_rep_type__charstring);
    (void) unite(Newqual@new_table_info__opt_reps, Bottom, option__absent);
    if (new_table(dst, Newqual->value) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    (void) Finalize(Newqual);
    (void) Finalize(Infocopy);
    return(FAILURE);
}


status
bag_new_table(dst)
objectp dst;
{
    lobject(Newqual);
    
    set_bottom(Newqual);
    
    if (new_record(Newqual, new_table_info) isnt Normal) goto cleanup;
    (void) unite(Newqual@new_table_info__nonlookup, Bottom, 
		 table_rep_type__linklist);
    (void) unite(Newqual@new_table_info__opt_reps, Bottom, option__absent);
    if (new_table(dst, Newqual->value) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    discard(Newqual);
    return(FAILURE);
}

status
avl_new_table(dst, keyset)
objectp dst, keyset;
{
    status make_avl();

    return(make_avl(dst, keyset, (objectp) nil));
}



static status
make_avl(dst, keyset, nonlookup)
objectp dst, keyset, nonlookup;
{
    status avl_new();
    lobject(Reps);
    lobject(Rep);

    set_bottom(Reps);
    set_bottom(Rep);

    if (!vec_new_table(Reps, keyqual)) goto cleanup;
    (void) unite(Rep, Bottom, table_rep_type__keyavl);
    if (insert(Reps, Rep) isnt Normal) goto cleanup;
    if (!avl_new(dst, keyset, Reps, nonlookup)) goto cleanup;
    return(SUCCESS);

  cleanup:
    Finalize(Reps);
    Finalize(Rep);
    return(FAILURE);
}


status
ord_avl_new_table(dst, keyset, ordinfo)
objectp dst, keyset, ordinfo;
{
    lobject(Nonlookup);

    set_bottom(Nonlookup);
    if (!vec_qual(Nonlookup, ordinfo))
      return(FAILURE);
    return(make_avl(dst, keyset, Nonlookup));
}

status
avl2_new_table(dst, keyset)
objectp dst, keyset;
{
    status avl_new();

    lobject(Reps);
    lobject(Rep);

    set_bottom(Reps);
    set_bottom(Rep);

    if (!vec_new_table(Reps, keyqual)) goto cleanup;
    (void) unite(Rep, Bottom, table_rep_type__keyavl);
    if (insert(Reps, Rep) isnt Normal) goto cleanup;
    (void) unite(Rep, Bottom, table_rep_type__keyavl);
    if (insert(Reps, Rep) isnt Normal) goto cleanup;
    if (!avl_new(dst, keyset, Reps, (objectp) nil)) goto cleanup;
    return(SUCCESS);

  cleanup:
    Finalize(Reps);
    Finalize(Rep);
    return(FAILURE);
}


static status
avl_new(dst, keyset, reps, nonlookup)
objectp dst, keyset;
objectp reps;
objectp nonlookup;
{
    lobject(Newqual);
    lobject(Linfo);

    set_bottom(Newqual);
    set_bottom(Linfo);

    if (new_record(Newqual, new_table_info) isnt Normal) goto cleanup;
    if (nonlookup)
      (void) move(Newqual@new_table_info__nonlookup, nonlookup);
    else
      (void) unite(Newqual@new_table_info__nonlookup, Bottom, 
		   table_rep_type__none);
    if (new_record(Linfo, lookup_info) isnt Normal) goto cleanup;
    (void) move(Linfo@lookup_info__reps, reps);
    if (copy(Linfo@lookup_info__keys, keyset) isnt Normal) goto cleanup;
    if (!vec_new_table(Linfo@lookup_info__indices, keyqual)) goto cleanup;
    (void) unite(Newqual@new_table_info__opt_reps, Linfo, option__present);
    if (new_table(dst, Newqual->value) isnt Normal) goto cleanup;
    return(SUCCESS);

  cleanup:
    if (!isbottom(Newqual)) {
	if (nonlookup)
	  (void) move(nonlookup, Newqual@new_table_info__nonlookup);
	if (!isbottom(Newqual@new_table_info__opt_reps))
	  (void) dissolve(Linfo, Newqual@new_table_info__opt_reps);
	if (!isbottom(Linfo)) {
	    (void) move(reps, Linfo@lookup_info__reps);
	    Finalize(Linfo);
	}
	Finalize(Newqual);
    }
    return(FAILURE);
}
