-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)putline.p	1.2 3/13/90

putLine: using (predefined, terminalIO, terminalInits, unix)
process (initQ: initPutStringQ)

declare
  init: initPutStringIntf;
  fputs: fputs_function;
  file: handle;
  putStringQ: putStringQ;
  putString: putStringIntf;
  newline: charstring;
  rc: int;

begin
  receive init from initQ;
  fputs := init.fputs;
  file := init.file;
  new putStringQ;
  connect init.putString to putStringQ;
  return init;

  new newline;
  insert char#'NL' into newline;

  while boolean#'true' repeat
    receive putString from putStringQ;

    if boolean#(int#(fputs(putString.string, file)) >= int#0) then
      return putString;
    else
      discard putString;
    end if;

    rc := int#(fputs(newline, file));

  end while;
end process
