-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
fdhandlers: using (predefined,common,unix)
  definitions
    -- read sits on a fd and reads it
    readInit: callmessage (
	in: unix!handle,
	read: readFn
      )
    constant (in)
    exit {full};
    readInitQ: inport of readInit {init(in)};
    readInitFn: outport of readInitQ;

    read: callmessage (
	data: charstring,
	success: boolean
      )
    exit {full};
    readQ: inport of read {};
    readFn: outport of readQ;

    -- write sits on a fd and writes it
    writeInit: callmessage (
	out: unix!handle,
	write: writeFn
      )
    constant (out)
    exit {full};
    writeInitQ: inport of writeInit {init(out)};
    writeInitFn: outport of writeInitQ;

    write: callmessage (
	data: charstring,
	success: boolean
      )
    constant(data)
    exit {full};
    writeQ: inport of write {init(data)};
    writeFn: outport of writeQ;

    -- close closes both fd's down
    closeInit: callmessage (
	in: unix!handle,
	out: unix!handle,
	close: closeFn
      )
    constant (in,out)
    exit {full};
    closeInitQ: inport of closeInit {init(in),init(out)};
    closeInitFn: outport of closeInitQ; 

    close: callmessage (
      )
    exit {};
    closeQ: inport of close {};
    closeFn: outport of closeQ;

  end definitions
