-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)root.d	1.3 3/13/90

root: using (cLoad, common) definitions 

-- this module describes the interface to the root process which is created
-- when the hermes system is initialized.

  rootInitMessage: record (
    CLoader: CLoad!CLoadFn,		-- capability to create special 
					--  processes written in C.

    argv: common!charstringList,	-- tokens on the command line that 
					--  started this hermes system

    environ: environ,			-- variables of the environment in 
					--  which this system was started

    directory: charstring		-- directory from which we were 
					--  started.
  );

  rootInitMessageQ: inport of rootInitMessage { full };

  -- there is no outport definition, because this message is magically
  -- enqueued in this port before the root process begins executing.


  environ: table of enventry { full } keys (variable);

  enventry: record (
    variable: charstring,		-- name of the variable, (ie, "TERM")
    value: charstring			-- its value (ie, "ibm3101")
  );

end definitions


