/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)makeroot.ch	1.13 3/13/90";
#endif

#include <sys/param.h>
#include <string.h>

#include "cfunc.h"
#include "storage.h"
#include "procenv.h"
#include "recursiv.h"
#include "ops.h"

#include "root.cd"

#define MAXVARSIZE 256


void
make_rootmsg(argc, argv, sched, Rootmsg)
int argc;
char *argv[];
schedblock *sched;
objectp Rootmsg;
{
    extern char **environ;

    char *getenv();
    void load_cload();
    char *getwd();
    void abort_nili();
    char *hrootdir();

    hobject(String, charstring);
    hobject(Entry, record);
    hobject(Newroot, record);
    char envvar[MAXVARSIZE];
    int i, eqindex, varlen;
    char pathname[MAXPATHLEN];
    char *hroot;


    set_bottom(Newroot);
    set_bottom(String);
    set_bottom(Entry);
    set_bottom(Rootmsg);

    if (new_record(Newroot, rootinitmessage) isnt Normal) goto cleanup;
    load_cload(sched, Newroot@rootinitmessage__cloader);
    if (!vec_new_table(Newroot@rootinitmessage__argv, (objectp) nil))
      goto cleanup;
    if (!avl_new_table(Newroot@rootinitmessage__environ, firstelem_key))
      goto cleanup;
    (void) getwd(pathname);
    if (!chs_lit(Newroot@rootinitmessage__directory, pathname))
      goto cleanup;
    
    for (i = 0; i < argc; i++) {
	if (!chs_lit(String, argv[i]))
	  goto cleanup;
	if (insert(Newroot@rootinitmessage__argv, String) isnt Normal)
	  goto cleanup;
    }

    if (getenv("HROOTDIR") is nil) {
				/* if no user-supplied root, fake on up. */

	hroot = hrootdir();	/* get pointer to (static) root string */

	if (new_record(Entry, enventry) isnt Normal) goto cleanup;
	if (not chs_lit(Entry@enventry__variable, "HROOTDIR")) goto cleanup;
	if (not chs_lit(Entry@enventry__value, hroot)) goto cleanup;
	if (insert(Newroot@rootinitmessage__environ, Entry) isnt Normal)
	  goto cleanup;
    }

    for (i = 0; environ[i] isnt nil; i++) {
	if (new_record(Entry, enventry) isnt Normal) goto cleanup;
	eqindex = strcspn(environ[i], "=");
	varlen = min(eqindex, MAXVARSIZE-1);
	(void) strncpy(envvar, environ[i], varlen);
	envvar[varlen] = nil;
	
	if (!chs_lit(Entry@enventry__variable, envvar)) goto cleanup;
	if (!chs_lit(Entry@enventry__value, environ[i]+eqindex+1))
	  goto cleanup;
	if (insert(Newroot@rootinitmessage__environ, Entry) isnt Normal)
	  goto cleanup;
    }
    (void) move(Rootmsg, Newroot);
    return;

  cleanup:
    Finalize(String, F_DISCARD, sched);
    Finalize(Entry, F_DISCARD, sched);
    Finalize(Newroot, F_DISCARD, sched);
    nilerror("make_rootmsg","out of memory");
    abort_nili("make_rootmsg");
}

void
create_root(sched, Rootmsg)
schedblock *sched;
objectp Rootmsg;
{
    char *getenv();
    pcb *create_proc();
    void abort_nili();
    char *hbindir();

    lobject(Rootname);
    lobject(Rootprog);
    lobject(Rootport);
    pcb *proc;
    char *rootfile = nil;
    char *hbin;
    
    set_bottom(Rootname);
    set_bottom(Rootprog);
    set_bottom(Rootport);

    if ((rootfile = getenv("HROOTPROG")) is nil) {
      hbin = hbindir();
      if ((rootfile = (char *) getmain(strlen(hbin)+strlen("/root.po")+1))
	  is nil)
	goto cleanup;
      sprintf(rootfile, "%s/root.po", hbin);
    }

    if (!chs_lit(Rootname, rootfile)) goto cleanup;
    if (read(Rootprog, Rootname) isnt Normal)
      goto cleanup;
    if ((proc = create_proc(Rootprog->value.program)) is nil)
      goto cleanup;
    proc->type = Process;
    (void) c_connect(Rootport, & proc->ep.h->data[INITPORT]);
    if (c_send(sched, Rootport, Rootmsg) isnt Normal)
      goto cleanup;
    sched->add(sched, proc);
    return;

  cleanup:
    Finalize(Rootport, F_DISCARD, sched);
    Finalize(Rootprog, F_DISCARD, sched);
    Finalize(Rootname, F_DISCARD, sched);
    if (getenv("HROOTPROG") is nil and rootfile isnt nil)
      freemain(rootfile, strlen(rootfile)+1);
    nilerror("create_root", "Creation of root process failed; exiting");
    abort_nili("create_root");
}
