/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)print.c	1.7 3/13/90";
#endif

#include <stdio.h>

#include "ops.h"
#include "recursiv.h"
#include "accessors.h"

#define VARIANT_COMPONENT 0


/*ARGSUSED*/
void prt_noop(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    (void) fprintf(f, "**** No print routine for this data representation!!! ****\n");
}



/*ARGSUSED*/
void
prt_ord_scalar(f, indent, v)
FILE *f;
int indent;
valcell v;
{
    (void) fprintf(f, "%d\n", v.integer);
}




/*ARGSUSED*/
void
prt_boolean(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    if (val.boolean)
      (void) fprintf(f, "True\n");
    else
      (void) fprintf(f, "False\n");
}


/*ARGSUSED*/
void
prt_nominal(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    (void) fprintf(f, "[%u,%u]\n", val.nominal->time, val.nominal->num);
}


/*ARGSUSED*/
void
prt_ord_enumeration(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    if (val.ord_enum > ' ' and val.ord_enum < '~')
      (void) fprintf(f, "%3d or '%c'\n", val.ord_enum, val.ord_enum);
    else
      (void) fprintf(f, "%d\n", val.ord_enum);
}



void
prt_record(f, indent, record)
FILE *f;
int indent;
valcell record;
{
    void re_print();
    void indent_for_print();

    counter size, i;
    

    size = record.record->info.record_size;
    
    indent++;
    (void) fprintf(f, "\n");

    for (i = 0; i < size; i++)
				/* print each of the components */
      re_print(f, indent, & record.record->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Record\n");
}



void
prt_program(f, indent, program)
FILE *f;
int indent;
valcell program;
{
    void re_print();
    void indent_for_print();

    counter i;
    

    indent++;
    (void) fprintf(f, "\n");

    for (i = 0; i < PROGRAM_SIZE; i++)
				/* print each of the components */
      re_print(f, indent, & program.program->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Program\n");
}



void
prt_callmessage(f, indent, cm)
FILE *f;
int indent;
valcell cm;
{
    void re_print();
    void indent_for_print();

    counter i;
    

    indent++;
    (void) fprintf(f, "\n");

    for (i = 0; i < cm.callmessage->info.callmessage->size; i++)
				/* print each of the components */
      re_print(f, indent, & cm.callmessage->data[i]);

    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Callmessage\n");
}



void
prt_variant(f, indent, val)
FILE *f;
int indent;
valcell val;
{
    void re_print();
    void indent_for_print();


    (void) fprintf(f,"\n");
    indent_for_print(f, indent+1);
    (void) fprintf(f, "case %d --\n", val.variant->info.variant_case);

    re_print(f, indent+1, & val.variant->data[VARIANT_COMPONENT]);


    indent_for_print(f, indent);
    (void) fprintf(f, "End of Variant\n");
}



void
prt_inport(f, indent, ip)
FILE *f;
int indent;
valcell ip;
{
    void indent_for_print();

    message *msgp;
    datarep *tsdr;
    local_inport *p;

    p = & ip.inport->info.inport;

    tsdr = p->tsdr;

    if (tsdr)
      (void) fprintf(f, "holds messages of type %s", tsdr->name);
    else
      (void) 
	fprintf(f, "holds messages of unknown type (queue should be empty)");

    (void) fprintf(f, ", connected to %d outports", ip.inport->refcount);

    if (ip.inport->disconnected)
      (void) fprintf(f, ", disconnected");

    if (p->waiting_owner)
      (void)
	fprintf(f, ", awaited by process at %u", p->waiting_owner);


    indent++;
    for (msgp = p->queue; msgp isnt nil; msgp = msgp->next) {
	indent_for_print(f, indent);
	if (tsdr)
	  (*tsdr->print)(f, indent, msgp->value);
	else
	  (void) fprintf(f, "Unable to print queued object\n");
    }
    indent_for_print(f, --indent);
    (void) fprintf(f, "End of Inport\n");
}



void
print_keyset(f, keyset, keyname)
FILE *f;
dfd_table *keyset;
char *keyname;
{
    int key, field, offset, theoffset;
    valcell thekey, thefield;


    if (keyset->size is 0)
      return;

    (void) fprintf(f, ", %s ", keyname);

    for (key = 0; key < keyset->size; key++) {
	thekey = vec_elem(keyset, key);

	if (size_of(get_elem(thekey,0)) is 0)
	  (void) fprintf(f, "(*)");
	else {
	    (void) fprintf(f, "(");
	    for (field = 0; field < size_of(thekey); field++) {
		if (field > 0)
		  (void) fprintf(f, ",");

		thefield = get_elem(thekey, field);

		for (offset = 0; offset < size_of(thefield); offset++) {
		    if (offset > 0)
		      (void) fprintf(f, ".");

		    theoffset = get_elem(thefield, offset).integer;
		    (void) fprintf(f, "%d", theoffset);
		}
	    }
	    (void) fprintf(f, ") ");
	}
    }
}


void
prt_polymorph(f, indent, poly)
FILE *f;
int indent;
valcell poly;
{
    void indent_for_print();
    void re_print();

    (void) fprintf(f, "\n");
    re_print(f, indent+1, & poly.polymorph->obj);
    indent_for_print(f, indent);
    (void) fprintf(f, "End of Polymorph\n");
}
