/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)recursiv.h	1.5 3/13/90 */

/*
 * recursiv.h
 *
 * definitions for modules that define or use operators that recursively
 * traverse nil objects.  currently, these are finalize, copy, and equal.
 */

#define Finalize(objectp, f_op, sched) \
                         (*(objectp)->tsdr->finalize)((objectp)->value, \
						      (f_op), (sched))
#define Copy(dst,src)    (*(src)->tsdr->copy)(&(dst)->value,(src)->value)
#define Equal(obj1,obj2) (*(obj1)->tsdr->equal)((obj1)->value, (obj2)->value)
#define Print(file, indent, obj) \
                         (*(obj)->tsdr->print)(file,indent,(obj)->value)

#define Rep extern datarep 

Rep dr_bottom;
Rep dr_boolean;
