/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
#ifndef lint
static char sccsinfo[] = "@(#)tbldes.c	1.6 3/13/90";
#endif

#include "li.h"

#include "interpform.cd"

#define ORDERED nil, nil, nil, nil


/******************************************************************************
 *             Object Vector Ordered Table Representation                    *
 *****************************************************************************/

void
  vec_uninsert(), vec_remove(), vec_endget(), vec_remove_at(),
  vec_unmerge_at(), vec_lookup_at();
int
  vec_position_of(), vec_foreach();
predef_exception
  vec_insert(), vec_get(), vec_insert_at(), vec_merge_at(), vec_conc_at();
void
  vec_finalize();
status
  vec_alloc(), vec_precopy(), vec_initget(), vec_equal();
comparison
  vec_comparekeys();


static tbldes vec_tbldes = {
    table_rep_type__vector,	/* description number */
    "Vector",
    Ordered_Table,

    vec_alloc,			/* ubiquitous functions */
    vec_precopy,
    vec_insert,
    vec_uninsert,
    vec_foreach,
    vec_initget,
    vec_get,
    vec_remove,
    vec_endget,
    vec_finalize,
    vec_equal,
    vec_comparekeys,

    ORDERED,			/* placeholder */

    vec_insert_at,		/* ordered table functions */
    vec_remove_at,
    vec_lookup_at,
    vec_merge_at,
    vec_unmerge_at,
    vec_position_of,
    vec_conc_at
};


/******************************************************************************
 *                Charstring Table Representation                             *
 *****************************************************************************/

void
  chs_uninsert(), chs_remove(), chs_endget(), chs_remove_at(), 
  chs_unmerge_at(), chs_lookup_at();
int
  chs_position_of(), chs_foreach();
predef_exception
  chs_insert(), chs_get(), chs_insert_at(), chs_merge_at(), chs_conc_at();
void
  chs_finalize();
status
  chs_alloc(), chs_precopy(), chs_initget(), chs_equal();
comparison
  chs_comparekeys();

static tbldes chs_tbldes = {
    table_rep_type__charstring,	/* description number */
    "Charstring",
    Ordered_Table,

    chs_alloc,			/* ubiquitous functions */
    chs_precopy,
    chs_insert,
    chs_uninsert,
    chs_foreach,
    chs_initget,
    chs_get,
    chs_remove,
    chs_endget,
    chs_finalize,
    chs_equal,
    chs_comparekeys,

    ORDERED,			/* placeholder */

    chs_insert_at,		/* ordered table functions */
    chs_remove_at,
    chs_lookup_at,
    chs_merge_at,
    chs_unmerge_at,
    chs_position_of,
    chs_conc_at
};


/******************************************************************************
 *                    AVL Tree Table Representation                           *
 *****************************************************************************/

void
  avl_uninsert(), avl_remove(), avl_endget();
int
  avl_foreach();
predef_exception
  avl_insert(), avl_get();
void
  avl_finalize();
status
  avl_alloc(), avl_initget(), avl_equal(), avl_find();
comparison
  avl_comparekeys();

static tbldes avl_tbldes = {
    table_rep_type__keyavl,	/* description number */
    "AVL Tree",
    Keyed_Table,

    avl_alloc,			/* ubiquitous functions */
    avl_alloc,			/* precopy = alloc */
    avl_insert,
    avl_uninsert,
    avl_foreach,
    avl_initget,
    avl_get,
    avl_remove,
    avl_endget,
    avl_finalize,
    avl_equal,
    avl_comparekeys,

    avl_find
};



/******************************************************************************
 *                    Linked-List Bag Representation                          *
 *****************************************************************************/

void
  ll_uninsert(), ll_remove(), ll_endget();
int
  ll_foreach();
predef_exception
  ll_insert(), ll_get();
void
  ll_finalize();
status
  ll_alloc(), ll_initget(), ll_equal();
comparison
  ll_comparekeys();


static tbldes ll_tbldes = {
    table_rep_type__linklist,	/* description number */
    "Linked List",
    Bag_Table,

    ll_alloc,			/* ubiquitous functions */
    ll_alloc,			/* precopy = alloc */
    ll_insert,
    ll_uninsert,
    ll_foreach,
    ll_initget,
    ll_get,
    ll_remove,
    ll_endget,
    ll_finalize,
    ll_equal,
    ll_comparekeys
};

/******************************************************************************
 *                        Array of Table Representations                      *
 *****************************************************************************/

tbldes *tbldescriptors[] = {
    nil,			/* none */
    & vec_tbldes,		/* vector */
    & chs_tbldes,		/* charstring */
    nil,			/* dublink */
    & avl_tbldes,		/* keyavl */
    nil,			/* keyhash */
    nil,			/* bitset */
    nil,			/* indexavl */
    nil,			/* indexhash */
    & ll_tbldes			/* linklist */
  };
