-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rShellExec.p
-- Author: Andy Lowry
-- SCCS Info: @(#)rshellexec.p	1.2 3/13/90

-- This process is initialized with a user-level resource manager.  It
-- then waits for an remote shell request and spawns a pshell to
-- handle it.

rShellExec: using (rShell, rShellInt, rMain, rManager, load, common)
linking (ac_none)

process (initQ: rShellExecQ)
  
declare
  initArgs: rShellExec;
  rm: rManager;
  Q: rShellQ;
begin
  receive initArgs from initQ;
  rm := initArgs.rm;
  new Q;
  connect initArgs.rShell to Q;
  return initArgs;
  discard initQ;
  
  -- now field the rshell request itself
  block declare
    args: rShell;
    pshell: rMainFn;
    pathLoad: load_func;
    resource: polymorph;
    argv: charStringList;
  begin
    receive args from Q;
    unwrap pathLoad from rm.get("pathLoad", "") {init};
    pshell <- create of pathLoad("pshell");
    wrap copy of args.stdin as resource;
    call rm.post("stdin", resource, create of process ac_none);
    wrap copy of args.stdout as resource;
    call rm.post("stdout", resource, create of process ac_none);
    new argv;
    insert "rshell" into argv;
    insert "pshell" into argv;
    insert copy of args.cmdLine into argv;
    wrap argv as resource;
    call rm.post("argv", resource, create of process ac_none);
    call pshell(rm);
    return args;
  end block;
end process
