-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: dcomshell.p
-- Author: Daniel Yellin
-- SCCS Info: "@(#)dcomshell.p	1.3 3/13/90"
-- recieves a process name + env and returns the function to invoke dcom on that name
dcomshell: using(main,common,root,stdenv,unix,cload,make,getdep)
process(ActionInitQ: ActionInitq)

declare
ActionInitArgs: ActionInitIntf;
dcom: main!main_Func;
q: ActionQ;
fn: ActionFunc;
args: ActionIntf;
environ: root!environ;
std: stdenv!stdenv;
unix: unix!unix;
CLoader: cload!CLoadFn;
argv: common!charstringList;

begin
receive ActionInitArgs from ActionInitQ;
dcom <- create of ActionInitArgs.std.pathload("dcom");

environ := ActionInitArgs.environ;
std := ActionInitArgs.std;
unix := ActionInitArgs.unix;
CLoader := ActionInitArgs.CLoader;
new argv; 

-- insert the command line into the arguments list   (hermi dcom <name>)i
insert "hermi" into argv;  
insert "dcom" into argv;
insert copy of ActionInitArgs.name into argv; 

new q;
connect fn to q;
ActionInitArgs.action <- fn;
return ActionInitArgs;

-- wait for call
   receive args from q;
block begin
   call dcom(argv,environ,std,unix,CLoader);
   args.made <- 'true';  -- compilation success
on (Disconnected)   -- if dcom bombs out
   args.made <- 'false'; -- compilation failure
end block;

return args;
end process
