-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initloadfuncs.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initloadfuncs.d	1.2 3/13/90"
-- description:
-- initFindfileFuncs is given some capabilities and returns 5 functions.
-- The first four funcs are findfile functions -- they locate a return a file
-- relative to a unix path
initloadfuncs: using(unix,root,load,cwd,findfile)
definitions 

initloadfuncsIntf: callmessage(
  access: unix!access_Func,
  getcwd: cwd!getCwdFn,
  pathload: load!load_func,
  environ: root!environ,  
  findfilePO: findfile!findfile_func,
  findfileDO: findfile!findfile_func,
  findfilePsrc: findfile!findfile_func,
  findfileDsrc: findfile!findfile_func 
) constant(access, getcwd, pathload, environ)
  exit {full}
  minimum {full(access), full(getcwd), full(pathload), full(environ)};

initloadfuncsQ: inport of initloadfuncsIntf {full(access), full(getcwd),
                                     full(pathload), full(environ)};
initloadfuncsFn: outport of initloadfuncsQ;

end definitions
