-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rightmostchar.p
-- Author: Daniel M. Yellin
-- SCCS info: "@(#)rightmostchar.p	1.3 3/13/90"
-- description:
-- this takes a char and a string and returns the position of the 
-- rightmost instance of the char in the string.  It returns -1 if 
-- the char doesn't exist in the string.  (charposition.p returns the 
-- position of the leftmost instance of char in string).
rightmostchar: using(predefined, getuses)
process (Q: CharPosQ)

declare
  args: CharPosIntf;
  found: boolean;
  pos: integer;

begin
  receive args from Q;
  found := 'false';
  args.pos <- -1;
  pos := size of args.s - 1;
  while (not found) and pos >= 0 repeat
    if args.c = args.s[pos]
    then
      args.pos := pos; found := 'true';
    else pos <- pos - 1;
    end if;
  end while;
  return args;
end process
