-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: acpipe.d
-- Author: Andy Lowry
-- SCCS Info: @(#)acpipe.d	1.2 3/13/90

-- Definitions for the access function that grants access to pipe ends
-- on behalf of the plumber

-- Initialize the access function with a capability to load a piece of
-- code ... two access capabilities are returned, one for the source
-- and one for the sink

acPipe: using (rmanager, load)

definitions

  acPipe: callmessage (
    load: load_func,
    sourceAC: accessFn,
    sinkAC: accessFn
  )
  constant (load)
  exit {full};
  
  acPipeQ: inport of acPipe {init(load)};
  acPipeFn: outport of acPipeQ;

  -- the two ends of a pipe
  pipeEnd: enumeration ('source', 'sink');

end definitions

