-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: complement.p
-- Author: Andy Lowry
-- SCCS Info: @(#)complement.p	1.2 3/13/90

-- This is a filter for boolean pipes.  The incoming booleans are all
-- complemented and then sent on.

complement: using (rmain, booleanpipe)

process (Q: rmainQ)
  
declare
  args: rmain;
  stdin: booleanQ;
  stdout: booleanPort;
  bool: boolean;
begin
  receive args from Q;
  
  -- Get the pipe ports we'll need
  unwrap stdin from args.rm.get("stdin", "boolean") {init};
  unwrap stdout from args.rm.get("stdout", "boolean") {init};
  
  while 'true' repeat
    receive bool from stdin;
    send not bool to stdout;
  end while;
  
end process
