-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: matchstrings.p
-- Author: Andy Lowry
-- SCCS Info: @(#)matchstrings.p	1.2 3/13/90

-- This process reads strings from stdin and generates booleans on
-- stdout indicating, for each input string, whether it matches a
-- prefix string specified as the first command line argument

matchstrings: using (rmain, stringpipe, booleanpipe, common)

process (Q: rmainQ)
  
declare
  args: rmain;
  argv: charStringList;
  prefix: charString;
  stdin: stringQ;
  stdout: booleanPort;
  i: integer;
  s: charString;
begin
  receive args from Q;
  
  -- Get the prefix string from the command line args
  unwrap argv from args.rm.get("argv", "") {init};
  prefix := argv[2];		-- skip shell name and program name
  
  -- Get input and output pipe ports
  unwrap stdin from args.rm.get("stdin", "string") {init};
  unwrap stdout from args.rm.get("stdout", "boolean") {init};
  
  -- Now go match strings
  while 'true' repeat
    block begin
      receive s from stdin;
      i <- 0;
      while (i < size of prefix) repeat
	if (s[i] <> prefix[i]) then
	  exit noMatch;
	end if;
	i <- i + 1;
      end while;
      -- all chars matched... this one's a match
      send 'true' to stdout;
    on exit(noMatch)
      send 'false' to stdout;
    on (notFound)
      send 'false' to stdout;
    end block;
  end while;
  
end process
