-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pshell.d
-- Author: Andy Lowry
-- SCCS Info: @(#)pshell.d	1.2 3/13/90

-- Internal definitions need by the pshell

pshell: using (common, rmain, tokenize, plumbing, rmanager)

definitions
  
  -- Interface for command line parser.  See pshell.p for details on
  -- the syntax.
  parseProcNet: callmessage (
    rm: rManager,
    cmd: tokenList,		-- tokenized command line
    procs: procSet,		-- processes comprising network
    pipes: pipeSet,		-- pipes connecting network processes
    asynchronous: boolean,	-- false means plumber should wait for all
				-- network processes to return before
				-- returning
    failer: charString
  )
  constant (rm, cmd)
  exit {full(rm), init(cmd), init(procs), init(pipes), init(asynchronous)}
  exception procFailure {init(cmd), init(failer)}
  exception pipeFailure {init(cmd), init(failer)}
  exception syntaxError {init(cmd)};
  
  parseProcNetQ: inport of parseProcNet {full(rm), init(cmd)};
  parseProcNetFn: outport of parseProcNetQ;
  
  -- interface for process to parse a single process specification
  parseProc: callmessage (
    toks: tokenList,
    procs: procInfoSet,
    labels: procLabels,
    proc: procID
  )
  exit {full}
  exception syntaxError {init(toks), init(procs), init(labels)};
  
  parseProcQ: inport of parseProc {init(toks), init(procs), init(labels)};
  parseProcFn: outport of parseProcQ;
  
  -- interface to process which will parse a pipe specification
  parsePipe: callmessage (
    toks: tokenList,
    pipe: pipeInfo
  )
  exit {full}
  exception syntaxError {init(toks)};
  
  parsePipeQ: inport of parsePipe {init(toks)};
  parsePipeFn: outport of parsePipeQ;
  
  -- interface to a process that will load a named program and return
  -- an rmain capability that will post a given argument string vector
  -- as resource "argv" and then invoke the loaded process
  wrapArgs: callmessage (
    rm: rManager,
    name: charString,
    argv: charStringList,
    wrappedProc: rmainFn
  )
  constant (rm, name, argv)
  exit {full}
  exception Failure {full(rm), init(name), init(argv)};

  wrapArgsQ: inport of wrapArgs {full(rm), init(name), init(argv)};
  wrapArgsFn: outport of wrapArgsQ;

  -- table relating process labels to their procID's
  procLabels: table of procLabel {full} keys (label);
  procLabel: record (
    label: charstring,
    proc: procID,
    defined: boolean
  );

  -- States in the top-level parser state machine
  topState: enumeration ('proc', 'pipe', 'done');

  -- States in process parser state machine
  procState: enumeration ('start', 'getColon', 'gotLabel', 'args', 'done');

  -- States in pipe parser state machine
  pipeState: enumeration ('start', 'name1', 'comma', 'name2', 'rBracket',
    'done');

  -- Info about a parsed process specification, not yet resolved into
  -- the procSet representation
  procInfoSet: table of procInfo {full} keys (id);
  procInfo: record (
    id: procID,
    name: charString,
    args: charStringList
  );

  -- Info about a parsed pipe, not yet resolved into the pipeSet
  -- representation
  pipeInfoSet: table of pipeInfo {full};
  pipeInfo: record (
    id: pipeID,
    source: procID,
    sourceName: charString,
    dest: procID,
    destName: charString
  );

  -- Saved parser info in top-level parser, saved across <..> constructs
  parseStack: ordered table of parseInfo {full};
  parseInfo: record (
    pushedFrom: topState,
    source: procID,
    pipes: pipeInfoSet
  );

end definitions
