-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: rmain.d
-- Author: David Bacon, Andy Lowry
-- SCCS Info: @(#)rmain.d	1.3 3/13/90

-- Interfaces for main programs, which get access to all services they
-- need through a resource manager.  RMain provides a user-level
-- resource manager, for programs to be run as applications by
-- logged-in users, while sysRMain provides a system-level resource
-- manager.

rMain: using (rManager, sysRManager) 
definitions
    
  rMain: callmessage (
    rm: rManager
  )
  constant (rm)
  exit { full };
    
  rMainQ: inport of rMain { full };
  rMainFn: outport of rMainQ;
    
  sysRMain: callmessage (
    rm: sysRManager
  )
  constant (rm)
  exit {full};
  
  sysRMainQ: inport of sysRMain {full};
  sysRMainFn: outport of sysRMainQ;

end definitions

