-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)sh.p	1.4 3/13/90

sh: using (predefined, main, unixcmd)
process (initQ: main_Q)

declare
  init: main_intf;
  unixcmd: unixCmdFunc;
  cmd: charstring;
  status: integer;

begin
  receive init from initQ;

  new cmd;

  for arg in init.argv where (boolean#'true') inspect
    if boolean#(integer#(position of arg) >= integer#3) then
      insert char#' ' into cmd;
    end if;

    if boolean#(integer#(position of arg) >= integer#2) then
      merge charstring#(copy of arg) into cmd;
    end if;
  end for;

  unixcmd <- unixCmdFunc#(create of program#(init.std.pathload(charstring#
    "unixcmd")));
  call unixcmd(cmd, init.unix.stdio.popen, 
    init.unix.stdio.pclose, init.unix.stdio.fgets, 
    init.std.terminal.putString, status);

  return init;

on (unixCmd.cantExec)
  call init.std.terminal.putString(charstring#"sh: couldn't exec """);
  call init.std.terminal.putString(cmd);
  call init.std.terminal.putLine(charstring#""".");
  return init;

on (unixCmd.programException)
  call init.std.terminal.putLine(charstring#"sh: non-zero return code.");
  return init;

end process
