-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)integer.p	1.3 3/13/90 
-- checks that the argument is of type integer
integer: using(type)
PROCESS(ClassQ: ClassRuleQueue)
DECLARE
  ClassM: ClassRuleMessage;

BEGIN
  RECEIVE ClassM FROM ClassQ;
  INSPECT definitions_module IN ClassM.definitions 
    	WHERE(definitions_module.id = ClassM.argument.moduleid)
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(type_def.id = ClassM.argument.typeid)
    BEGIN
      BLOCK BEGIN
	REVEAL type_def.specification.integer_info;
	ClassM.result <- 'true';
      ON (CaseError) -- the argument is not an integer type
	ClassM.result <- 'false';
      END BLOCK;
    END INSPECT;
  END INSPECT;
  RETURN ClassM;
END process
