-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)numeric.p	1.3 3/13/90 
-- checks that the argument is a numeric type (an integer or a real)
numeric: using(type)
PROCESS(ClassQ: ClassRuleQueue)
DECLARE
  ClassM: ClassRuleMessage;

BEGIN
  RECEIVE ClassM FROM ClassQ;
  INSPECT definitions_module IN ClassM.definitions 
    	WHERE(definitions_module.id = ClassM.argument.moduleid)
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(type_def.id = ClassM.argument.typeid)
    BEGIN
      SELECT CASE OF type_def.specification
      WHERE('integertype') ClassM.result <- 'true';
      WHERE('realtype') ClassM.result <- 'true';
      OTHERWISE ClassM.result <- 'false';
      END SELECT;
    END INSPECT;
  END INSPECT;
  RETURN ClassM;
END process

