-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: podissolve.p
-- Author: Rob Strom
-- SCCS Info: @(#)podissolve.p	1.1 7/27/89

podissolve : USING( tscheck, Predefined  ) PROCESS (PostKillVariantInit : DeterminePostconditionInport )
-- Compute Postcondition of DISSOLVE
-- Identical to MakeUninit, except that it's the parent of the variant component
-- which is made uninit
-- Algorithm:
-- 1. Drop last component from source object
-- 2. Do "makeuninit", namely:
--    For each attribute involving source object, 
--    put that attribute in the Drops list
-- 3. Include INIT(Variant) even if it is not present
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    VariantObject: ObjectName; -- variant object
    DeletedComponent: ComponentId; -- removed component
    AttributesInvolvingSource : Typestate; -- attributes involving it
    AttributeInvolvingSource: Attribute; -- one of the above attributes
    EmptyAttributeList:  Typestate;
  BEGIN
    RECEIVE FP FROM PostKillVariantInit ;
    INSPECT SourceObject IN FP.Statement.Operands WHERE(POSITION OF SourceObject = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
      BEGIN
	-- 1.
	VariantObject := SourceObject;
	REMOVE DeletedComponent FROM Component IN VariantObject.Components WHERE(POSITION OF Component = SIZE OF VariantObject.Components - 1);
	NEW EmptyAttributeList; 
	CALL FP.Services.Involving(FP.CurrentTS, VariantObject, EmptyAttributeList, AttributesInvolvingSource);
        BLOCK
          BEGIN
            WHILE('true')
              REPEAT
                REMOVE AttributeInvolvingSource FROM A IN AttributesInvolvingSource WHERE('true');
                BLOCK
                  BEGIN
                    INSERT AttributeInvolvingSource INTO FP.NormalPostcondition.Drops;
                  ON (DuplicateKey)
                  END BLOCK;
              END WHILE;
          ON (NotFound)
          END BLOCK;
        BLOCK 
          BEGIN
	    INSERT EVALUATE InitSource: Attribute FROM
	      NEW InitSource;
	      NEW InitSource.Objects;
	      UNITE InitSource.Name.Init FROM EVALUATE Empty: Empty FROM END;
	      INSERT COPY OF VariantObject INTO InitSource.Objects;
	    END INTO FP.NormalPostcondition.Drops;
	  ON(DuplicateKey)
	  END BLOCK;
      END INSPECT;
    RETURN FP;
  END PROCESS
