-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomakecase.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomakecase.p	1.2 3/13/90

pomakecase : USING( tscheck, Predefined  ) PROCESS (PostMakeCaseInit : DeterminePostconditionInport )
-- Create CASE(V, V.X) Postcondition
-- Algorithm:
-- 1. Operand is V.X.  Make the attribute CASE(V, V.X) and insert to Adds
-- 2. Put INIT(V) into Adds
-- 3. Put case typestate into Adds if not already there
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    X: ComponentId;
    V: ObjectName;
    VDotX: ObjectName;
    Case: Attribute; -- Case(V, V.X)
    InitV: Attribute; -- INIT(V)
    VType: TypeName;
    Attr: Attribute; -- case typestate attribute
    CaseTypestate: Typestate; -- case typestate
  BEGIN
    RECEIVE FP FROM PostMakeCaseInit ;
    VDotX <- Object IN FP.Statement.Operands WHERE(POSITION OF Object = Offset in FP.Affected_Operands WHERE(POSITION OF Offset = 0));
    V := VDotX;
    REMOVE X FROM Component IN V.Components WHERE(POSITION OF Component = SIZE OF V.Components - 1);
    NEW Case;
    NEW Case.Objects;
    UNITE Case.Name.Case FROM EVALUATE Null: Empty FROM END;
    INSERT COPY OF V INTO Case.Objects;
    INSERT COPY OF VDotX INTO Case.Objects;
    NEW InitV;
    NEW InitV.Objects;
    UNITE InitV.Name.Init FROM Evaluate Null2: Empty FROM END;
    INSERT COPY OF V INTO InitV.Objects;
    INSERT Case INTO FP.NormalPostcondition.Adds;
    INSERT InitV INTO FP.NormalPostcondition.Adds;
    Vtype <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, V);
    INSPECT Module IN FP.Definitions WHERE(Module.Id = VType.ModuleId)
      BEGIN
	INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = VType.TypeId)
	  BEGIN
	    -- 2.
	    REVEAL Definition.Specification.Variant_Info; 
	    INSPECT Mapping IN Definition.Specification.Variant_Info.Case_Mapping WHERE(Mapping.Component_Id = X)
	      BEGIN
	        CALL FP.Services.Substitute(FP.Services, VDotX, Mapping.Case_Typestate, CaseTypestate);
	      END INSPECT;
	    -- 3.
	    BLOCK
	      BEGIN
	        WHILE ('true')
	          REPEAT
	            REMOVE Attr FROM A IN CaseTypestate WHERE('true');
	            BLOCK
	              BEGIN
	                INSERT Attr INTO FP.NormalPostcondition.Adds;
	              ON (DuplicateKey)
	              END BLOCK;
	          END WHILE;
	      ON (NotFound)
	      END BLOCK;
	  END INSPECT;
      END INSPECT;
    RETURN FP;
  END PROCESS
