-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: pomakefull.p
-- Author: Rob Strom
-- SCCS Info: @(#)pomakeinit.p	1.1 7/27/89

pomakefull : USING( tscheck, Predefined , pomakefull ) PROCESS (PostMakeFullInit : DeterminePostconditionInport )
-- Create Init Postcondition
-- Algorithm:
-- 1. Add INIT(Object) to the Adds List
-- 2. If Object is a record, then for each component, makefull that component
--    
  DECLARE
    FP: DeterminePostconditionCall ;
    Makefull: RecursivePostconditionOutport;
    Source: ObjectName;
  BEGIN
    RECEIVE FP FROM PostMakeFullInit ;
    Source <- Object IN FP.Statement.Operands WHERE(POSITION OF Object = Offset in FP.Affected_Operands WHERE(POSITION OF Offset = 0));
    Makefull <- procedure of process (Init: RecursivePostconditionInport)
      declare
        FP: RecursivePostconditionCall;
        Type: TypeName;
        Makefull: RecursivePostconditionOutport;
      begin
        RECEIVE FP FROM Init;
        -- 1.
        INSERT (Evaluate INITX: Attribute FROM
          NEW InitX;
          NEW InitX.Objects;
          UNITE InitX.Name.Init FROM EVALUATE Nothing: Empty FROM END;
          INSERT COPY OF FP.Source INTO InitX.Objects;
          END) INTO FP.NormalPostcondition.Adds;
        -- 2.
	Type <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, FP.Source);
	INSPECT CAModule IN FP.Definitions WHERE(CAModule.Id = Type.ModuleId)
	  BEGIN
	    INSPECT CADefinition IN CAModule.Type_definitions WHERE(CADefinition.Id = Type.TypeId)
	      BEGIN
		IF CASE OF CADefinition.Specification = 'recordtype'
		  THEN
		    Makefull <- procedure of currentprogram;
		    FOR Component IN CADefinition.Component_Declarations[]
		      INSPECT
		         CALL Makefull(FP.Services, FP.Declarations, FP.Context, FP.Definitions, EVALUATE Subcomponent: ObjectName FROM
		           Subcomponent := FP.Source;
		           INSERT COPY OF Component.Id INTO Subcomponent.Components;
		           END, FP.CurrentTS, FP.NormalPostcondition);
		      END FOR;
		  END IF;
	      END INSPECT;
	  END INSPECT;
	RETURN FP;
      END PROCESS;
    CALL Makefull(FP.Services, FP.Declarations, FP.Context, FP.Definitions, Source, FP.CurrentTS, FP.NormalPostcondition);
    RETURN FP;
  END PROCESS
