-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: preinsert.p
-- Author: Rob Strom
-- SCCS Info: @(#)preinsert.p	1.2 3/13/90

-- preinsert:  Precondition for INSERT(AT)
-- Algorithm:
-- 2. Get element formal typestate of T
-- 3. Substitute Element.  This will be the required TS
-- 4. Attributes Involving Obj will be the forbidden TS
preinsert : USING( tscheck, Predefined ) PROCESS ( PreLowestElementStateInit : DeterminePreconditionInport)
  DECLARE
    FP: DeterminePreconditionCall ;
    TType: Typename; -- the table's type
    ElementTypestate: Typestate; -- the element typestate
    HigherAttributes: Typestate; -- additional attributes above element typestate
    
  BEGIN
    RECEIVE FP FROM PreLowestElementStateInit ;
    INSPECT Table IN FP.Statement.Operands WHERE(POSITION OF Table = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 1))
      BEGIN
        INSPECT Element IN FP.Statement.Operands WHERE(POSITION OF Element = Offset IN FP.Affected_Operands WHERE(POSITION OF Offset = 0))
          BEGIN
	    Ttype <- FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, Table);
	    INSPECT Module IN FP.Definitions WHERE(Module.Id = TType.ModuleId)
	      BEGIN
		INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = TType.TypeId)
		  BEGIN
		    -- 2, 3.
		    REVEAL Definition.Specification.Table_Info; 
		    CALL FP.Services.Substitute(FP.Services, Element, Definition.Specification.Table_Info.Element_Typestate, ElementTypestate);
		    -- 4.
		    CALL FP.Services.Involving(FP.CurrentTS, Element, ElementTypestate, HigherAttributes);
		    MERGE ElementTypestate INTO FP.Required;
		    MERGE HigherAttributes INTO FP.Forbidden; 
		  END INSPECT;
	      END INSPECT;
	  END INSPECT;
      END INSPECT;
    RETURN FP;
    on (Others)
      print charstring # "something wrong in prelowestelementstate";
  END PROCESS
