-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
safewindow:  using(safewindowgen, safewindow, safewindowinit, window, main, CLoad, terminalio, common) linking(safewindowgen, window) process (init: safewindowinitQ)
  declare 
    parms: safewindowInit;
    safewindowgen: safewindowgenFn; -- generate safewindow callmessage
    windowmaker: windowFn; -- generate a window
    CLoader: CLoad!CLoadfn; -- C loader
    openwindow: safewindowQ; -- open window service port
    openRQ: safewindow; -- request to open a window
    terminalQ: terminalQ; -- port for receiving terminal functions as CM
  begin
    -- initialization
    safewindowgen <- procedure of process safewindowgen;
    windowmaker <- procedure of process window;
    receive parms from init;
    CLoader := parms.CLoader;
    new openwindow;
    connect parms.open to openwindow;
    return parms;
    new terminalQ;
    
    -- service loop
    while ('true') 
      repeat
        receive openRQ from openwindow;
        block
          declare
            terminal: terminalFunctions; -- terminal functions for the window
            close: signalPort; -- access to close signal for the window
          begin
            call windowmaker(CLoader, openRQ.label, openRQ.options, terminal, close);
            call safewindowgen(terminal, close, terminalQ);
            receive openRQ.terminal from terminalQ;
            return openRQ;
          on (window.Failure)
            return openRQ exception Failure;
          end block;
      end while;
  end process
