/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */

#include <stdio.h>
#include <suntool/sunview.h>
#include <suntool/tty.h>

char reverse[256];

Frame frame;

Tty tty;
int fd;

char line[1024];

int done;
Notify_value interposer(frame,func)
     Notify_client frame;
     Destroy_status func;
{
  char *fake;

  if (func!=DESTROY_CHECKING)
    {
      /* Shutdown my side of the window */
      fake = "<Fake out>\n";
      ttysw_input(tty,fake,strlen(fake));
      done = 1;
    }
  return NOTIFY_DONE;
}

main(argc,argv)
     int argc;
     char *argv[];
{
  int i;
  int result;
  char c;

  /* Setup */
  for (i=0;i<256;i++)
    reverse[i] = i;
  for (i='A';i<='Z';i++)
    reverse[i] = i-'A'+'a';
  for (i='a';i<='z';i++)
    reverse[i] = i-'a'+'A';
  /* Create a tty subwindow */
  frame = window_create(NULL,FRAME,FRAME_LABEL,"A simple tty example.",0);
  tty = window_create(frame,TTY,TTY_ARGV,TTY_ARGV_DO_NOT_FORK,0);
  fd = (int) window_get(tty,TTY_TTY_FD);
  /* Set up for implicit notification */
  done = 0;
  notify_interpose_destroy_func(frame,interposer);
  window_set(frame,WIN_SHOW,TRUE,0);
  notify_do_dispatch();
  /* Read strings, reverse their case, and write them again, until you type "Done". */
  do {
    /* Read in a line */
    i = 0;
    do {
      result = read(fd,&c,1);
      if (result <= 0) goto finis;
      line[i++] = c;
    } while (c!='\n');
    line[i]='\0';
    for (i=0;line[i];i++)
      line[i] = reverse[line[i]];
    write(fd,line,strlen(line));
  } while (!done);
 finis:
  printf("Done.\n");
}
