-- a tutorial front end to run the bounded buffer
bbintf :  using(main,string, stdenv,bbexternal, quit,standard)
  linking(atoi,itoa)
process(Init: main_Q)
declare
  cm: main_intF;
  atoi:string2intFn;
  itoa:int2stringFn;
  BBcapacity:integer;
  Put:PutLineOut;
  Get:GetLineOut;
  Quit:QuitOut;
  bb:BBOut;
  line:charstring;
  errormsg:charstring;
  cmd:char;
  space:char;
begin
  receive cm from init;
  
  -- front end for the bounded buffer
  -- bounder buffer provides the services put, get and quit:
  -- line formats:
  -- P <rest of line>   put <rest of line> to bounded buffer
  -- G              get a line from bounded buffer and print it
  -- Q              quit, shutting down bounded buffer
  
  -- start up bounded buffer, optional capacity as an argument
  -- repeatedly get lines from the terminal
  -- select on first character
  
  
  bb := create of cm.std.pathLoad( cm.argv[2] );
  BBcapacity := 3;   -- default
  if (size of cm.argv > 3)
  then
    block begin
      atoi := create of process atoi;
      BBcapacity := atoi(cm.argv[3]);
    on (string2int.badFormat)
      call cm.std.terminal.putLine( cm.argv[3] | " not an integer.");
    end block;
  end if;
  itoa := create of process itoa;
  call cm.std.terminal.putLine( "Initializing "| cm.argv[2] | " with capacity " |itoa( BBcapacity ) | ".");
  call bb( BBcapacity, Put, Get, Quit);
  
  block begin
    while 'true' repeat
      call cm.std.terminal.putString("bbintf prompt: "  );
      call cm.std.terminal.getString( line );
      if (size of Line > 0)
      then
        remove cmd from Line[0];
        select (cmd)
        
          where ('P')
          remove space from Line[0];
            call cm.std.terminal.putLine( "Putting `" | Line | "' into bounded buffer.");
            -- this will deadlock if the bounded buffer is full
            call Put(Line);
            
          where ('G')
            -- this will deadlock if the bounded buffer is empty
            Line := Get();
            call cm.std.terminal.putLine( "Getting `"|Line| "' from bounded buffer.");
          where ('Q')
            call cm.std.terminal.putLine( "Quitting bounded buffer." );
            call Quit();
            exit quitting;
            
          otherwise
            errormsg :=  "Unknown bbintf command: ";
            insert cmd into errormsg;
            call cm.std.terminal.putLine( errormsg );
          end select;
        end if;
      end while;
    on exit (quitting)
    end block;
    
    return cm;
  end process
