
RepositoryExternal: using() definitions

Resource: polymorph;

PostInterface: callmessage(
  ResourceName: Charstring, -- name being given to resource
  PostedResource: Resource, -- resource being posted
  AccessFunction: AccessOut) -- access control function
  constant(ResourceName, AccessFunction)
  exit {full}
  exception DuplicateName {full};
PostIn: inport of PostInterface {full};
PostOut: outport of PostIn;

AccessInterface: callmessage(
  UserName: Charstring, -- name of the requestor
  PostedResource: Resource, -- resource originally posted
  ReturnedResource: Resource) -- the resource granted
  constant(UserName, PostedResource)
  exit {full}
  exception AccessDenied {init(UserName), init(PostedResource)};
AccessIn:inport of AccessInterface {init(UserName),init(PostedResource)};
AccessOut: outport of AccessIn;

RequestInterface: callmessage(
  ResourceName: Charstring, -- name of resource being requested
  Resource:  Resource) -- the resource granted
  constant(ResourceName)
  exit {full}
  exception NotFound {init(ResourceName)}
  exception AccessDenied {init(ResourceName)};
RequestIn: inport of RequestInterface {init(ResourceName)};
RequestOut: outport of RequestIn;


end definitions

