tutorial_041 : using(Standard, WMExternal, WMInt, StartWindowApplication)
  process (Init: WMIn)
  declare
    Parms: WMInterface; -- initialization parameters
    Dispatch: PutLineIn; DispatchCM: PutLineInterface;
    Refocus: WindowIn; RefocusCM: WindowInterface;
    Kill: WindowIn; KillCM: WindowInterface;
    Create: CreateIn; CreateCM: CreateInterface;
    WriteToWindow: WriteToWindowIn; WriteToWindowCM: WriteToWindowInterface;
    GetProgram: GetProgramOut;
    PutLine: PutLineOut;
    WriteToWindowCapability: WriteToWindowOut;
    ApplicationBuilder: Program;
    Lines: integer; -- number of lines since last prompt
    CreatedWindows: Windows; -- status of all windows
    CurrentFocus: Charstring; -- name of window in focus
    CurrentWindow: Window; -- a window being insert/deleted/searched
  begin
    -- initialization section
    receive Parms from Init;
    GetProgram := Parms.GetProgram;
    PutLine := Parms.PutLine;
    
    ApplicationBuilder := Parms.GetProgram("ApplicationBuilder");
    
    new Dispatch; connect Parms.Dispatch to Dispatch;
    new Refocus; connect Parms.Refocus to Refocus;
    new Kill; connect Parms.Kill to Kill;
    new Create; connect Parms.Create to Create;
    new WriteToWindow; connect WriteToWindowCapability to WriteToWindow;
    Lines := 0;
    new CreatedWindows;
    CurrentFocus := ":";
    -- service section
    while ('true') repeat
        if Lines = 20
          then
            call PutLine(CurrentFocus | ":");
            Lines := 0;
          end if;
        select
        event Dispatch  --
        event Refocus  --
        event Kill  --
        event Create  --
        receive CreateCM from Create;
        if exists of CreatedWindows[CreateCM.WindowName]
          then
            -- error action if window already exists
          else
            block begin
                new CurrentWindow;
                CurrentWindow.WindowName := CreateCM.WindowName;
                
                while ('true') repeat
                call ( WindowApplicationOut # (create of ApplicationBuilder)) (
                
                  CreateCM.ProgramName, CreateCM.ParmString,
                  GetProgram, WriteToWindowCapability, CurrentWindow.WindowName,
                  CurrentWindow.InputToWindow, CurrentWindow.Quit
                  
                  );
                  end while;
                  
                  
                on (WindowApplicationInterface.NotCreated)
                -- error action if unable to create process
                end block;
              end if;
            return CreateCM;
            event WriteToWindow  --
            otherwise
            end select;
          Lines := Lines + 1;
        end while;
    end process
    
    
    
