
WindowManager: using(Standard, WMExternal, WMInt, StartWindowApplication)
  process (Init: WMIn)
  declare
    Parms: WMInterface; -- initialization parameters
    Refocus: WindowIn;
    RefocusCM: WindowInterface;
    WriteToWindow: WriteToWindowIn;
    WriteToWindowCM: WriteToWindowInterface;
    Dispatch: DispatchIn;
    DispatchCM: DispatchInterface;
    Create: CreateIn;
    CreateCM: CreateInterface;
    Kill: WindowIn;
    KillCM: WindowInterface;
    GetProgram: GetProgramOut;
    PutLine: PutLineOut;
    WriteToWindowCapability: WriteToWindowOut;
    ApplicationBuilder: Program;
    CreatedWindows: Windows; -- status of all windows
    CurrentFocus: Charstring; -- name of window in focus
    CurrentWindow: Window; -- a window being insert/deleted/searched
  begin
    -- initialization section
    receive Parms from Init;
    GetProgram := Parms.GetProgram;
    PutLine := Parms.PutLine;
    ApplicationBuilder := Parms.GetProgram("applicationbuilder");
    new Refocus; connect Parms.Refocus to Refocus;
    new WriteToWindow; connect WriteToWindowCapability to WriteToWindow;
    new Dispatch; connect Parms.Dispatch to Dispatch;
    new Create; connect Parms.Create to Create;
    new Kill; connect Parms.Kill to Kill;
    return Parms;
    
    new CreatedWindows;
    -- service section
    while ('true') repeat
        select
        
        -- event Refocus ...
        
        event Refocus
          receive RefocusCM from Refocus;
          if exists of CreatedWindows[RefocusCM.WindowName]
          then
            return RefocusCM;
          else
            -- error action
            return RefocusCM exception NotFound;
          end if;
          
          
          
          -- event WriteToWindow ...
          
          event WriteToWindow
            receive WriteToWindowCM from WriteToWindow;
            call PutLine(WriteToWindowCM.WindowName | ": " | WriteToWindowCM.Line);
            return WriteToWindowCM;
            
            
            -- event Dispatch ...
            
            event Dispatch
              block begin
                receive DispatchCM from Dispatch;
                CurrentWindow := CreatedWindows[DispatchCM.WindowName];
                call CurrentWindow.InputToWindow(DispatchCM.Line);
                return DispatchCM ;
              on(NotFound)
                return DispatchCM exception NotFound;
              end block;
              
              
              -- event Create ...
              
              event Create
                receive CreateCM from Create;
                
                if exists of CreatedWindows[CreateCM.WindowName]
                then
                  -- error action because window already exists
                  return CreateCM exception Duplicate;
                else
                  block begin
                      new CurrentWindow;
                      CurrentWindow.WindowName := CreateCM.WindowName;
                      call ( WindowApplicationOut # (create of ApplicationBuilder))
                        (CreateCM.ProgramName, CreateCM.ParmString,
                        GetProgram, WriteToWindowCapability, CurrentWindow.WindowName,
                        CurrentWindow.InputToWindow, CurrentWindow.Quit);
                      insert CurrentWindow into CreatedWindows;
                      return CreateCM;
                    on (WindowApplicationInterface.NotCreated)
                      -- error action if unable to create process
                      return CreateCM exception CreateFailure;
                    end block;
                  end if;
                  
                  
                  
                  -- event Kill ...
                  
                  event Kill
                    receive KillCM from Kill;
                    block begin
                      remove CurrentWindow from CreatedWindows[KillCM.WindowName];
                      call CurrentWindow.Quit();
                      discard CurrentWindow;
                      return KillCM;
                    on (NotFound)
                      -- error action
                      return KillCM exception NotFound;
                    end block;
                    
                    
                    
                    otherwise
                  end select;
                end while;
              end process
              
