/* (C) Copyright International Business Machines Corporation 12 September */
/* 1991.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)chtail.h	1.3 2/17/92 */

/* Exception handling for C-coded Hermes functions. */
  /*  The including program defines INTERPRET .  */

ch_case_error :
  ch_val.enumeration = CaseError;
  goto ch_builtin_handler;

ch_depletion :
  ch_val.enumeration = Depletion;
  goto ch_builtin_handler;

ch_dividebyzero :
  ch_val.enumeration = DivideByZero;
  goto ch_builtin_handler;

ch_notfound :
  ch_val.enumeration = NotFound;
  goto ch_builtin_handler;

ch_range_error :
  ch_val.enumeration = RangeError;
  goto ch_builtin_handler;

ch_raise_exception :
  ch_val.enumeration = ch_returncode;

ch_builtin_handler :
  ch_e = handler_type__builtin;

ch_exception :
  set_error(current, ch_e, ch_val);
  current->ip = raise_exception(current);
#ifdef INTERPRET
escape:
  cop =  get_elem(dcdot(current->code, prog__code),
		  current->ip);
  if (dot(cop, operation__opcode).integer != opcode__escape) {
    current->interpreter = nil;
    return;
  }
#endif
  goto select;
}
