-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
makebb: using(usub, terminalio, safewindow, rManager, common, ac_filtered) linking(make_ac_filtered) process (init: usubIn)
  declare
    parms: usub; -- initialization parameters
    openwindow: safewindowFn; -- port to open a window
    rm: rManager; -- ports to resource manager
    calendarwindow: terminalCM; -- window opened by makebb
    makeac: make_ac_filtered_initOut; -- process making ac
    ac: accessFn; -- access control
    resource: polymorph; -- polymorph resource
    junk: charstring;
    unauth: charstringList;
  begin
    -- Algorithm:
    -- 0. Save  rm
    -- 1. Get services: OpenWindow
    -- 2. Create a new window 
    -- 3. Post its terminal into the resource manager
    -- 4. prompt for when you're ready to shut down
    receive parms from init;
    makeac <- procedure of process make_ac_filtered;
    new unauth;
    -- 0.
    BLOCK
      declare
      BEGIN
        rm := parms.io.resource;
        -- 1.
        unwrap openwindow from rm.get("OpenWindow", "") {init};
        -- 2.
        calendarwindow <- openwindow("Bulletin Board", "-Wh 20 -Ww 40");
        -- 3.
        insert "art" into unauth;
        ac <- makeac(unauth, parms.io.terminal.PutLine);
        wrap copy of calendarwindow.terminal.putLine as resource;
        call rm.post("BB", resource, ac);
        -- 4. 
        call calendarwindow.terminal.putLine("BB started");
        call parms.io.terminal.putString("push enter to quit:");
        call parms.io.terminal.Getstring(junk);
        call rm.delete("BB");
        return parms;
      END BLOCK;
    
  end process
