-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
ac_filtered: using(common, terminalio, rManager) definitions

-- initialization port for make_ac_filtered
make_ac_filtered_init: callmessage(
  unauthorized: charstringList, -- who may not access
  notify: putStringFunc, -- port to send message if badguy tries
  ac: accessFn -- access control function
  )
  constant(unauthorized, notify)
  exit {full};
  
make_ac_filtered_initIn: inport of make_ac_filtered_init {full(unauthorized), full(notify)};
make_ac_filtered_initOut: outport of make_ac_filtered_initIn;

-- initialization port for filter
bbfilter_init: callmessage(
  bb: putstringFunc, -- access to bb
  username: charstring, -- userid
  fbb: putstringFunc -- filtered access to bb
  )
  constant(bb, username)
  exit {full};
bbfilter_initIn: inport of bbfilter_init {full(bb), full(username)};
bbfilter_initOut: outport of bbfilter_initIn;

end definitions
