-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
appt_scheduler_member:  USING (times, events)

DEFINITIONS

-- Appt_Scheduler -> Member calls:
	Request_Plan_Info : callmessage (
		Desired_Times : Time_Set,
		Available_Times : Time_Set ) -- The reply to the Request_Plan_Info
		constant( Desired_Times )
		exit {full};
	Request_Plan_Info_In : inport of Request_Plan_Info
		{ full(Desired_Times) };
	Request_Plan_Info_Out : outport of Request_Plan_Info_In;

	Inform_Schedule : callmessage (
		The_Event : An_Event )
		constant( The_Event )
		exit {full}
		exception Not_Scheduled{full(The_Event)};
	Inform_Schedule_In : inport of Inform_Schedule 
		{ full(The_Event) };
	Inform_Schedule_Out : outport of Inform_Schedule_In;

	Inform_Cancel : callmessage (
		Event_ID : Event_ID -- the event being cancelled
		)
		constant( Event_ID )
		exit {full}
		exception Not_Cancelled{full(Event_ID)};
	Inform_Cancel_In : inport of Inform_Cancel {full}; 
	Inform_Cancel_Out : outport of Inform_Cancel_In;

	Shutdown : callmessage ( )  -- Instruction to shutdown by the Appt_Scheduler
		constant( )
		exit {full};
	Shutdown_In : inport of Shutdown {};
	Shutdown_Out : outport of Shutdown_In;

	-- A command for the Member to empty its calendar - primarily for debugging
	Reset_Member : callmessage ( )
		constant( )
		exit {full};
	Reset_Member_In : inport of Reset_Member {};
	Reset_Member_Out : outport of Reset_Member_In;

-- Member -> Appt_Scheduler calls:
	Initiate_Plan : callmessage (
		Organizer: charstring,
		Desired_Times : Time_Set,
		Desired_Participants : Member_IDs,
		Uncontacted_Participants : Member_IDs, -- Set by the Scheduler
		-- Times when all Participants contacted are found to be available
		Available_Times : Time_Set )
		constant( Organizer, Desired_Times, Desired_Participants )
		exit {full};
	Initiate_Plan_In : inport of Initiate_Plan
		{ full(Organizer), full(Desired_Times), full(Desired_Participants) };
	Initiate_Plan_Out : outport of Initiate_Plan_In;

	Initiate_Schedule : callmessage (
		Scheduled_Time: Time_range,
		Organizer: charstring,
		Participants: Member_IDs,
		Annotation: charstring,
		Location: charstring,
		Event_ID: Event_ID, -- returned if successful
      -- if Not_Scheduled, who couldn't meet the schedule
		Unscheduled_Participants : Member_IDs 
		 )
		constant( Scheduled_Time, Organizer, Participants, 
			Annotation, Location) 
		exit {full(Scheduled_Time), full(Organizer), 
 		full(Participants), full(Annotation), full(Location), init(Event_Id)}
		exception Not_Scheduled{full(Scheduled_Time), full(Organizer), 
 		full(Participants), full(Annotation), full(Location),
         full(Unscheduled_Participants)};
	Initiate_Schedule_In : inport of Initiate_Schedule 
		{ full(Scheduled_Time), full(Organizer), 
 		full(Participants), full(Annotation), full(Location) };
	Initiate_Schedule_Out : outport of Initiate_Schedule_In;

	Initiate_Cancel : callmessage (  -- This cancels the event for everyone
		Organizer: charstring,
		Event_ID : Event_ID ) -- The event's ID
		constant( Event_ID, Organizer )
		exit {full}
		exception Cancel_Not_Permitted{full};
	Initiate_Cancel_In : inport of Initiate_Cancel {full}; 
	Initiate_Cancel_Out : outport of Initiate_Cancel_In;

	List_Members : callmessage (
		The_Members : Members )
		constant( )
		exit {full};
	List_Members_In : inport of List_Members {};
	List_Members_Out : outport of List_Members_In;

	-- Request for the full details on a set of Event_IDs
	List_Events : callmessage (
	        Organizer: charstring,
		The_Events : Table_Of_Events )
		constant( Organizer )
		exit {full};
	List_Events_In : inport of List_Events { full(Organizer) };
	List_Events_Out : outport of List_Events_In;

	Depart : callmessage (
	        Organizer: charstring -- who is departing
	        )  -- Announcement of departure by a member
		constant(Organizer)
		exit {full};
	Depart_In : inport of Depart {full(Organizer)};
	Depart_Out : outport of Depart_In;

end DEFINITIONS

