-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
umain:  USING (terminalio, common, rManager)
-- These are the access rights given to users when they start up
DEFINITIONS
  umain: callmessage(
    argv: charstringList, -- arguments from shell
    io: userAccess -- access rights to outside world
    )
    constant(argv)
    exit {full(argv)};
  umainIn: inport of umain {full}; -- users get io to keep until they die
  umainOut: outport of umainIn;
  
  useraccess: callmessage(
    username: charstring, -- name of user
    terminal: terminalFunctions, -- ability to read and write from a terminal device
    resource: rManager -- ability to get and post resources
    )
    constant(username, terminal, resource )
    exit {full};
  useraccessIn: inport of useraccess {full};
  useraccessOut: outport of useraccessIn;
  
end DEFINITIONS

